/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.text.MessageFormat;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class FileSizeRenderer
extends OutputRenderer {
    private boolean shortUnit;

    public boolean isShortUnit() {
        return this.shortUnit;
    }

    public void setShortUnit(boolean shortUnit) {
        this.shortUnit = shortUnit;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                if (object == null) {
                    return new HtmlText("");
                }
                Number number = (Number)object;
                long size = number.longValue();
                String message = size / 1024L == 0L ? MessageFormat.format("{0,number}" + (FileSizeRenderer.this.isShortUnit() ? "B" : "Bytes"), size) : (size / 0x100000L == 0L ? MessageFormat.format("{0,number,#}" + (FileSizeRenderer.this.isShortUnit() ? "KB" : "KBytes"), (double)size / 1024.0) : (size / 0x40000000L == 0L ? MessageFormat.format("{0,number,#.#}" + (FileSizeRenderer.this.isShortUnit() ? "MB" : "MBytes"), (double)size / 1048576.0) : MessageFormat.format("{0,number,#.##}" + (FileSizeRenderer.this.isShortUnit() ? "GB" : "GBytes"), (double)size / 1.073741824E9)));
                return new HtmlText(message);
            }
        };
    }
}

