/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.NumberInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DoubleInputRenderer
extends NumberInputRenderer {
    @Override
    protected Converter getConverter() {
        return new DoubleNumberConverter();
    }

    private class DoubleNumberConverter
    extends Converter {
        private DoubleNumberConverter() {
        }

        @Override
        public Object convert(Class type, Object value) {
            String numberText = ((String)value).trim();
            if (numberText.length() == 0) {
                return null;
            }
            try {
                return Double.parseDouble(numberText);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("renderers.converter.double", (Throwable)e, true, value);
            }
        }
    }
}

