/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.util.Locale;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenu;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenuOption;
import pt.ist.fenixWebFramework.renderers.converters.LocaleConverter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class LocaleInputRenderer
extends InputRenderer {
    private String defaultText;
    private String defaultTextBundle;
    private boolean defaultOptionHidden = false;
    private String bundle;
    private boolean key;
    private String excludedValues;
    private String includedValues;
    private boolean sort;
    private boolean readOnly;
    private boolean disabled;
    private String onChange;

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public boolean isDefaultOptionHidden() {
        return this.defaultOptionHidden;
    }

    public void setDefaultOptionHidden(boolean defaultOptionHidden) {
        this.defaultOptionHidden = defaultOptionHidden;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    private String getDefaultTitle() {
        if (this.getDefaultText() == null) {
            return RenderUtils.getResourceString("renderers.menu.default.title");
        }
        if (this.isKey()) {
            return RenderUtils.getResourceString(this.getDefaultTextBundle(), this.getDefaultText());
        }
        return this.getDefaultText();
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getDefaultTextBundle() {
        return this.defaultTextBundle;
    }

    public void setDefaultTextBundle(String defaultTextBundle) {
        this.defaultTextBundle = defaultTextBundle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                Locale selected = (Locale)object;
                HtmlMenu menu = new HtmlMenu();
                if (!LocaleInputRenderer.this.isDefaultOptionHidden()) {
                    String defaultOptionTitle = LocaleInputRenderer.this.getDefaultTitle();
                    menu.createDefaultOption(defaultOptionTitle).setSelected(selected == null);
                }
                if (LocaleInputRenderer.this.getOnChange() != null && !LocaleInputRenderer.this.getOnChange().trim().isEmpty()) {
                    menu.setOnChange(LocaleInputRenderer.this.getOnChange());
                }
                boolean supported = CoreConfiguration.supportedLocales().contains(selected);
                for (Locale locale : CoreConfiguration.supportedLocales()) {
                    HtmlMenuOption option = menu.createOption(locale.getDisplayName(I18N.getLocale()));
                    option.setValue(locale.toLanguageTag());
                    if (selected == null || !selected.equals(locale) && (supported || !selected.getLanguage().equals(locale.getLanguage()))) continue;
                    option.setSelected(true);
                }
                menu.setConverter(new LocaleConverter());
                menu.setTargetSlot((MetaSlotKey)LocaleInputRenderer.this.getInputContext().getMetaObject().getKey());
                return menu;
            }

            @Override
            public void applyStyle(HtmlComponent component) {
                super.applyStyle(component);
                HtmlFormComponent holderComponent = (HtmlFormComponent)component;
                holderComponent.setDisabled(LocaleInputRenderer.this.getDisabled());
            }
        };
    }
}

