/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class RegexpValidator
extends HtmlValidator {
    private String regexp;

    public RegexpValidator() {
        this(".*");
    }

    public RegexpValidator(String regex) {
        this.setRegexp(regex);
    }

    public RegexpValidator(HtmlChainValidator htmlChainValidator) {
        this(htmlChainValidator, ".*");
    }

    public RegexpValidator(HtmlChainValidator htmlChainValidator, String regexp) {
        super(htmlChainValidator);
        this.setRegexp(regexp);
        this.setMessage("renderers.validator.regexp");
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    @Override
    protected String getResourceMessage(String message) {
        return RenderUtils.getFormatedResourceString(this.getBundle(), message, this.getRegexp());
    }

    public String getValue() {
        return this.getComponent().getValue();
    }

    @Override
    public void performValidation() {
        String text = this.getValue();
        this.setValid(text.matches(this.getRegexp()));
    }

    @Override
    public boolean hasJavascriptSupport() {
        return true;
    }

    @Override
    protected String getSpecificValidatorScript() {
        return "function(element) { var text = $(element).attr('value');return text.length == 0 || text.match('" + this.getRegexp() + "');}";
    }
}

