/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;

public class MatrixRenderer
extends InputRenderer {
    private final List<CellConfiguration> cellConfigurations = new ArrayList<CellConfiguration>();

    private CellConfiguration getCellConfiguration(String slotId) {
        for (CellConfiguration cellConf : this.cellConfigurations) {
            if (!cellConf.getId().equals(slotId)) continue;
            return cellConf;
        }
        CellConfiguration cellConf = new CellConfiguration(slotId);
        this.cellConfigurations.add(cellConf);
        return cellConf;
    }

    public void setSlot(String id, String value) {
        this.getCellConfiguration(id).setSlotName(value);
    }

    public String getSlot(String id) {
        return this.getCellConfiguration(id).getSlotName();
    }

    public void setLabelHidden(String id, String value) {
        this.getCellConfiguration(id).setLabelHidden(Boolean.valueOf(value));
    }

    public String getLabelHidden(String id) {
        return this.getCellConfiguration(id).isLabelHidden().toString();
    }

    public void setColumn(String id, String value) {
        this.getCellConfiguration(id).setColumn(Integer.valueOf(value));
    }

    public String getColumn(String id) {
        return this.getCellConfiguration(id).getColumn().toString();
    }

    public void setRow(String id, String value) {
        this.getCellConfiguration(id).setRow(Integer.valueOf(value));
    }

    public String getRow(String id) {
        return this.getCellConfiguration(id).getRow().toString();
    }

    public void setColumnSpan(String id, String value) {
        this.getCellConfiguration(id).setColumnSpan(Integer.valueOf(value));
    }

    public String getColumnSpan(String id) {
        return this.getCellConfiguration(id).getColumnSpan().toString();
    }

    public void setRowSpan(String id, String value) {
        this.getCellConfiguration(id).setRowSpan(Integer.valueOf(value));
    }

    public String getRowSpan(String id) {
        return this.getCellConfiguration(id).getRowSpan().toString();
    }

    public void setLabelColumnSpan(String id, String value) {
        this.getCellConfiguration(id).setLabelColumnSpan(Integer.valueOf(value));
    }

    public String getLabelColumnSpan(String id) {
        return this.getCellConfiguration(id).getLabelColumnSpan().toString();
    }

    public void setLabelRowSpan(String id, String value) {
        this.getCellConfiguration(id).setLabelRowSpan(Integer.valueOf(value));
    }

    public String getLabelRowSpan(String id) {
        return this.getCellConfiguration(id).getLabelRowSpan().toString();
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new MatrixLayout(this.getContext().getMetaObject());
    }

    private static class CellConfiguration {
        private String id;
        private String slotName;
        private Boolean labelHidden;
        private Integer labelRowSpan;
        private Integer labelColumnSpan;
        private Integer rowSpan;
        private Integer columnSpan;
        private Integer column;
        private Integer row;

        public CellConfiguration(String id) {
            this.id = id;
            this.labelHidden = false;
            this.labelRowSpan = 1;
            this.labelColumnSpan = 1;
            this.rowSpan = 1;
            this.columnSpan = 1;
        }

        public Boolean isLabelHidden() {
            return this.labelHidden;
        }

        public void setLabelHidden(Boolean labelHidden) {
            this.labelHidden = labelHidden;
        }

        public Integer getLabelRowSpan() {
            return this.labelRowSpan;
        }

        public void setLabelRowSpan(Integer labelRowSpan) {
            this.labelRowSpan = labelRowSpan;
        }

        public Integer getLabelColumnSpan() {
            return this.labelColumnSpan;
        }

        public void setLabelColumnSpan(Integer labelColumnSpan) {
            this.labelColumnSpan = labelColumnSpan;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSlotName() {
            return this.slotName;
        }

        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        public Integer getRowSpan() {
            return this.rowSpan;
        }

        public void setRowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
        }

        public Integer getColumnSpan() {
            return this.columnSpan;
        }

        public void setColumnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
        }

        public Integer getColumn() {
            return this.column;
        }

        public void setColumn(Integer column) {
            this.column = column;
        }

        public Integer getRow() {
            return this.row;
        }

        public void setRow(Integer row) {
            this.row = row;
        }
    }

    public class MatrixLayout
    extends Layout {
        private final MetaObject metaObject;
        private Map<Integer, List<CellConfiguration>> matrix;
        private int maxColumns;
        private int maxRows;

        public MatrixLayout(Object object) {
            this.metaObject = (MetaObject)object;
            this.matrix = new HashMap<Integer, List<CellConfiguration>>();
            this.maxColumns = -1;
            this.maxRows = -1;
        }

        public Map<Integer, List<CellConfiguration>> getMatrix() {
            if (this.matrix == null) {
                this.createMatrix();
            }
            return this.matrix;
        }

        private void createMatrix() {
            this.matrix = new HashMap<Integer, List<CellConfiguration>>();
            for (CellConfiguration configuration : MatrixRenderer.this.cellConfigurations) {
                Integer row = configuration.getRow();
                List<CellConfiguration> cells = this.matrix.get(row);
                if (cells == null) {
                    cells = new ArrayList<CellConfiguration>();
                    this.matrix.put(row, cells);
                }
                cells.add(configuration);
                this.setMaxLinesAndRows(configuration);
            }
        }

        private void setMaxLinesAndRows(CellConfiguration configuration) {
            this.maxColumns = Math.max(this.maxColumns, configuration.getColumn());
            this.maxRows = Math.max(this.maxRows, configuration.getRow());
        }

        protected CellConfiguration getCell(int rowIndex, int columnIndex) {
            for (CellConfiguration configuration : this.getMatrix().get(rowIndex)) {
                if (!configuration.getColumn().equals(columnIndex)) continue;
                return configuration;
            }
            return null;
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            HtmlTable table = new HtmlTable();
            this.createMatrix();
            for (int row = 0; row <= this.maxRows; ++row) {
                HtmlTableRow tableRow = table.createRow();
                for (int column = 0; column <= this.maxColumns; ++column) {
                    CellConfiguration configuration = this.getCell(row, column);
                    if (configuration == null) continue;
                    MetaSlot slot = this.metaObject.getSlot(configuration.getSlotName());
                    if (!configuration.isLabelHidden().booleanValue()) {
                        HtmlTableCell headerCell = tableRow.createCell(HtmlTableCell.CellType.HEADER);
                        headerCell.setRowspan(configuration.getLabelRowSpan());
                        headerCell.setColspan(configuration.getLabelColumnSpan());
                        headerCell.setBody(new HtmlText(slot.getLabel()));
                    }
                    HtmlTableCell componentCell = tableRow.createCell(HtmlTableCell.CellType.DATA);
                    componentCell.setBody(MatrixRenderer.this.renderSlot(slot));
                    componentCell.setRowspan(configuration.getRowSpan());
                    componentCell.setColspan(configuration.getColumnSpan());
                }
            }
            return table;
        }
    }
}

