/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTimeFieldType;
import org.joda.time.base.AbstractPartial;
import pt.ist.fenixWebFramework.renderers.DateRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class PartialRenderer
extends DateRenderer {
    private boolean showFormat = false;
    private AbstractPartial partial;

    public boolean isShowFormat() {
        return this.showFormat;
    }

    public void setShowFormat(boolean showFormat) {
        this.showFormat = showFormat;
    }

    @Override
    public String getFormat() {
        if (this.isFormatSet()) {
            return super.getFormat();
        }
        String format = "dd/MM/yyyy HH:mm:ss";
        if (!this.partial.isSupported(DateTimeFieldType.dayOfMonth())) {
            format = format.replace("dd/", "");
        }
        if (!this.partial.isSupported(DateTimeFieldType.monthOfYear())) {
            format = format.replace("MM/", "");
        }
        if (!this.partial.isSupported(DateTimeFieldType.year())) {
            format = this.partial.isSupported(DateTimeFieldType.dayOfMonth()) || this.partial.isSupported(DateTimeFieldType.monthOfYear()) ? format.replace("/yyyy", "") : format.replace("yyyy", "");
        }
        if (!this.partial.isSupported(DateTimeFieldType.hourOfDay())) {
            format = format.replace("HH:", "");
        }
        if (!this.partial.isSupported(DateTimeFieldType.minuteOfHour())) {
            format = format.replace("mm:", "");
        }
        if (!this.partial.isSupported(DateTimeFieldType.secondOfMinute())) {
            format = this.partial.isSupported(DateTimeFieldType.hourOfDay()) || this.partial.isSupported(DateTimeFieldType.minuteOfHour()) ? format.replace(":ss", "") : format.replace("ss", "");
        }
        return format.trim();
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        this.partial = (AbstractPartial)object;
        final Date date = this.partial != null ? this.convertPartialToCalendar(this.partial).getTime() : null;
        final Layout superLayout = super.getLayout(date, type);
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                HtmlText text = (HtmlText)superLayout.createComponent(date, type);
                String formatText = PartialRenderer.this.isShowFormat() ? " (" + PartialRenderer.this.getFormat() + ")" : "";
                text.setText(text.getText() + formatText);
                return text;
            }
        };
    }

    private Calendar convertPartialToCalendar(AbstractPartial partial) {
        DateTimeFieldType[] fieldTypes;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        for (DateTimeFieldType fieldType : fieldTypes = partial.getFieldTypes()) {
            if (fieldType.equals(DateTimeFieldType.dayOfMonth())) {
                calendar.set(5, partial.get(DateTimeFieldType.dayOfMonth()));
                continue;
            }
            if (fieldType.equals(DateTimeFieldType.monthOfYear())) {
                calendar.set(2, partial.get(DateTimeFieldType.monthOfYear()) - 1);
                continue;
            }
            if (fieldType.equals(DateTimeFieldType.year())) {
                calendar.set(1, partial.get(DateTimeFieldType.year()));
                continue;
            }
            if (fieldType.equals(DateTimeFieldType.hourOfDay())) {
                calendar.set(11, partial.get(DateTimeFieldType.hourOfDay()));
                continue;
            }
            if (fieldType.equals(DateTimeFieldType.minuteOfHour())) {
                calendar.set(12, partial.get(DateTimeFieldType.minuteOfHour()));
                continue;
            }
            if (!fieldType.equals(DateTimeFieldType.secondOfMinute())) continue;
            calendar.set(13, partial.get(DateTimeFieldType.secondOfMinute()));
        }
        return calendar;
    }
}

