/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlRadioButton;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlRadioButtonGroup
extends HtmlSimpleValueComponent {
    private List<HtmlRadioButton> radioButtons = new ArrayList<HtmlRadioButton>();

    public List<HtmlRadioButton> getRadioButtons() {
        return this.radioButtons;
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        for (HtmlRadioButton radio : this.getRadioButtons()) {
            if (value != null && value.equals(radio.getValue())) {
                radio.setChecked(true);
                continue;
            }
            radio.setChecked(false);
        }
    }

    public HtmlRadioButton createRadioButton() {
        HtmlRadioButton radio = new HtmlRadioButton(){

            @Override
            public void setChecked(boolean checked) {
                HtmlRadioButtonGroup.this.setChecked(this, checked);
                super.setChecked(checked);
            }
        };
        this.getRadioButtons().add(radio);
        radio.setName(this.getName());
        return radio;
    }

    protected void setChecked(HtmlRadioButton button, boolean checked) {
        if (!checked) {
            return;
        }
        for (HtmlRadioButton radio : this.getRadioButtons()) {
            if (radio.equals(button)) continue;
            radio.setChecked(false);
        }
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        for (HtmlRadioButton radio : this.getRadioButtons()) {
            radio.setName(this.getName());
            if (this.getTargetSlot() == null) continue;
            radio.setTargetSlot(this.getTargetSlot());
        }
        return new HtmlText().getOwnTag(context);
    }
}

