/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Iterator;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLabel;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.FlowLayout;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;

public class FlowInputRenderer
extends InputRenderer {
    private String eachClasses;
    private String eachStyle;
    private String eachSchema;
    private String eachLayout;
    private boolean eachInline = true;
    private boolean labelExcluded = false;
    private String labelTerminator;
    private String labelClasses;
    private String labelStyle;
    private boolean hideValidators;
    private String validatorClasses;

    public String getEachClasses() {
        return this.eachClasses;
    }

    public void setEachClasses(String eachClasses) {
        this.eachClasses = eachClasses;
    }

    public boolean isEachInline() {
        return this.eachInline;
    }

    public void setEachInline(boolean eachInline) {
        this.eachInline = eachInline;
    }

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public String getEachStyle() {
        return this.eachStyle;
    }

    public void setEachStyle(String eachStyle) {
        this.eachStyle = eachStyle;
    }

    public boolean isLabelExcluded() {
        return this.labelExcluded;
    }

    public void setLabelExcluded(boolean labelExcluded) {
        this.labelExcluded = labelExcluded;
    }

    public boolean isHideValidators() {
        return this.hideValidators;
    }

    public void setHideValidators(boolean hideValidators) {
        this.hideValidators = hideValidators;
    }

    public String getValidatorClasses() {
        return this.validatorClasses;
    }

    public void setValidatorClasses(String validatorClasses) {
        this.validatorClasses = validatorClasses;
    }

    public String getLabelTerminator() {
        return this.labelTerminator;
    }

    public void setLabelTerminator(String labelTerminator) {
        this.labelTerminator = labelTerminator;
    }

    public String getLabelClasses() {
        return this.labelClasses;
    }

    public void setLabelClasses(String labelClasses) {
        this.labelClasses = labelClasses;
    }

    public String getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new FlowObjectInputRenderer(this.getInputContext().getMetaObject());
    }

    private class FlowObjectInputRenderer
    extends FlowLayout {
        private Iterator<MetaSlot> iterator;

        public FlowObjectInputRenderer(MetaObject object) {
            this.iterator = object.getSlots().iterator();
        }

        @Override
        protected boolean hasMoreComponents() {
            return this.iterator.hasNext();
        }

        @Override
        protected HtmlComponent getNextComponent() {
            MetaSlot slot = this.iterator.next();
            HtmlComponent component = FlowInputRenderer.this.renderSlot(slot);
            HtmlFormComponent validatedComponent = (HtmlFormComponent)FlowInputRenderer.this.findValidatableComponent(component);
            HtmlChainValidator chainValidator = FlowInputRenderer.this.getChainValidator(validatedComponent, slot);
            if (FlowInputRenderer.this.isLabelExcluded() && (chainValidator == null || chainValidator.isEmpty())) {
                return component;
            }
            return this.createContainer(slot, component, validatedComponent, chainValidator);
        }

        private HtmlInlineContainer createContainer(MetaSlot slot, HtmlComponent component, HtmlFormComponent validated, HtmlChainValidator chainValidator) {
            HtmlInlineContainer container = new HtmlInlineContainer();
            if (!FlowInputRenderer.this.isLabelExcluded()) {
                if (slot.isReadOnly()) {
                    container.addChild(new HtmlText(this.addLabelTerminator(slot.getLabel()), false));
                } else {
                    HtmlLabel label = new HtmlLabel();
                    label.setFor(slot.getKey().toString());
                    label.setText(this.addLabelTerminator(slot.getLabel()));
                    label.setClasses(FlowInputRenderer.this.getLabelClasses());
                    label.setStyle(FlowInputRenderer.this.getLabelStyle());
                    container.addChild(label);
                }
            }
            container.addChild(component);
            if (chainValidator != null && !FlowInputRenderer.this.isHideValidators()) {
                chainValidator.setClasses(FlowInputRenderer.this.getValidatorClasses());
                container.addChild(chainValidator);
            }
            return container;
        }

        protected String addLabelTerminator(String label) {
            if (FlowInputRenderer.this.getLabelTerminator() == null) {
                return label;
            }
            if (label == null) {
                return null;
            }
            if (label.endsWith(FlowInputRenderer.this.getLabelTerminator())) {
                return label;
            }
            return label + FlowInputRenderer.this.getLabelTerminator();
        }
    }
}

