/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.validators;

import org.joda.time.LocalDate;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class LocalDateValidator
extends HtmlValidator {
    private boolean required;
    private LocalDate calculatedDate;

    public LocalDateValidator() {
        this.setKey(true);
    }

    public LocalDateValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setKey(true);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void performValidation() {
        HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getComponent();
        String value = component.getValue();
        if (value == null || value.length() == 0) {
            this.setMessage("renderers.validator.dateTime.required");
            this.setValid(!this.isRequired());
        } else if (value.equals("invalid")) {
            this.setMessage("renderers.validator.dateTime.invalid");
            this.setValid(false);
        } else if (value.equals("incomplete")) {
            this.setMessage("renderers.validator.dateTime.incomplete");
            this.setValid(false);
        } else {
            String[] dateParts = value.split("/");
            if (dateParts.length == 3) {
                try {
                    int day = Integer.valueOf(dateParts[0]);
                    int month = Integer.valueOf(dateParts[1]);
                    int year = Integer.valueOf(dateParts[2]);
                    this.calculatedDate = new LocalDate(year, month, day);
                }
                catch (NumberFormatException e) {
                    this.setMessage("renderers.validator.dateTime.notNumbers");
                    this.setValid(false);
                }
                catch (IllegalArgumentException e) {
                    this.setMessage("renderers.validator.dateTime.invalid");
                    this.setValid(false);
                }
            } else {
                this.setMessage("renderers.validator.dateTime.invalid");
                this.setValid(false);
            }
        }
    }

    protected LocalDate getCalculatedDate() {
        if (this.isValid()) {
            return this.calculatedDate;
        }
        return null;
    }

    private boolean inRange(int value, int min, int max) {
        return value >= min && value <= max;
    }
}

