/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.servlets.ajax;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.fenixedu.bennu.core.presentationTier.renderers.autoCompleteProvider.AutoCompleteProvider;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.RequestChecksumFilter;

@WebServlet(value={"/ajax/AutoCompleteServlet"})
public class AutoCompleteServlet
extends HttpServlet {
    private static final long serialVersionUID = 6908539612870905011L;
    public static final String STYLE_CLASS = "styleClass";
    public static final String VALUE_FIELD = "valueField";
    public static final String FORMAT = "format";
    public static final String LABEL_FIELD = "labelField";
    public static final String MAX_COUNT = "maxCount";
    private static final String JAVASCRIPT_LIBRARY_ENCODING = Charsets.UTF_8.name();
    private static final int DEFAULT_MAX_COUNT = 20;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding(JAVASCRIPT_LIBRARY_ENCODING);
        if (!this.validateChecksum(request)) {
            if (request.getSession() != null) {
                request.getSession().invalidate();
            }
            response.setContentType("application/json; charset=" + JAVASCRIPT_LIBRARY_ENCODING);
            response.sendError(400);
            return;
        }
        String value = new String(request.getParameter("value").getBytes(), JAVASCRIPT_LIBRARY_ENCODING);
        Map<String, String> argsMap = this.getArgsMap(request.getParameter("args"));
        int maxCount = this.getNumber(request.getParameter(MAX_COUNT), 20);
        Collection<?> result = this.getSearchResult(argsMap, value, maxCount);
        String labelField = request.getParameter(LABEL_FIELD);
        String format = request.getParameter(FORMAT);
        String valueField = request.getParameter(VALUE_FIELD);
        String styleClass = request.getParameter(STYLE_CLASS);
        response.setContentType("application/json; charset=" + JAVASCRIPT_LIBRARY_ENCODING);
        response.getWriter().write(this.getResponseHtml(result, labelField, format, valueField, styleClass, maxCount));
    }

    private boolean validateChecksum(HttpServletRequest request) {
        String checksum = request.getParameter("_request_checksum_");
        if (checksum == null || checksum.length() == 0) {
            checksum = (String)request.getAttribute("_request_checksum_");
        }
        return this.isValidChecksum(request, checksum);
    }

    private boolean isValidChecksum(HttpServletRequest request, String checksum) {
        Object checksumRelevantString = "";
        checksumRelevantString = (String)checksumRelevantString + request.getParameter(MAX_COUNT);
        checksumRelevantString = (String)checksumRelevantString + request.getParameter(LABEL_FIELD);
        checksumRelevantString = (String)checksumRelevantString + request.getParameter(FORMAT);
        checksumRelevantString = (String)checksumRelevantString + request.getParameter(VALUE_FIELD);
        checksumRelevantString = (String)checksumRelevantString + request.getParameter(STYLE_CLASS);
        HttpSession session = request.getSession(false);
        return checksum.length() > 0 && (checksum.equals(GenericChecksumRewriter.calculateChecksum((String)checksumRelevantString, session)) || checksum.equals(GenericChecksumRewriter.calculateChecksum(RequestChecksumFilter.decodeURL((String)checksumRelevantString, JAVASCRIPT_LIBRARY_ENCODING), session)));
    }

    private int getNumber(String parameter, int defaultValue) {
        if (parameter == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(parameter);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected Collection<?> getSearchResult(Map<String, String> argsMap, String value, int maxCount) {
        AutoCompleteProvider<?> provider = this.getProvider(argsMap.get("provider"));
        return provider.getSearchResults(argsMap, value, maxCount);
    }

    private AutoCompleteProvider<?> getProvider(String providerClass) {
        try {
            Class<?> provider = Class.forName(providerClass);
            return (AutoCompleteProvider)provider.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot find provider " + providerClass);
        }
    }

    private Map<String, String> getArgsMap(String encodedServiceArgs) {
        String[] serviceArgsArray = encodedServiceArgs.split(",");
        HashMap<String, String> serviceArgsMap = new HashMap<String, String>();
        for (String serviceArg : serviceArgsArray) {
            String[] argNameArgValue = serviceArg.split("=");
            serviceArgsMap.put(argNameArgValue[0], argNameArgValue[1]);
        }
        return serviceArgsMap;
    }

    private String getResponseHtml(Collection<?> result, String labelField, String format, String valueField, String styleClass, int maxCount) {
        JsonArray jsonArray = new JsonArray();
        try {
            int count = 0;
            for (Object element : result) {
                if (count++ < maxCount) {
                    JsonObject object = new JsonObject();
                    object.addProperty("oid", BeanUtils.getProperty(element, (String)valueField));
                    if (format == null) {
                        object.addProperty("description", BeanUtils.getProperty(element, (String)labelField));
                    } else {
                        object.addProperty("description", RenderUtils.getFormattedProperties(format, element));
                    }
                    jsonArray.add((JsonElement)object);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error getting field property (see label and value fields)", ex);
        }
        return jsonArray.toString();
    }
}

