/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.utils;

import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.stream.Collectors;

public class CollectionPager<T> {
    private final Collection<T> collection;
    private final int perPage;

    public CollectionPager(Collection<T> collection, int perPage) {
        this.collection = collection;
        this.perPage = perPage;
    }

    public int getNumberOfPages() {
        return IntMath.divide((int)this.collection.size(), (int)this.perPage, (RoundingMode)RoundingMode.CEILING);
    }

    public Collection<T> getPage(int pageNum) {
        if (pageNum < 1) {
            pageNum = 1;
        }
        return this.collection.stream().skip((pageNum - 1) * this.perPage).limit(this.perPage).collect(Collectors.toList());
    }
}

