/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.util.ArrayList;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.model.CompositeSlotSetter;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;

public class SimpleMetaObject
extends MetaObject {
    private Object object;
    private int code;
    private final List<CompositeSlotSetter> compositeSetters;

    public SimpleMetaObject(Object object) {
        this.setObject(object);
        this.compositeSetters = new ArrayList<CompositeSlotSetter>();
    }

    protected void setObject(Object object) {
        this.object = object;
        this.code = object == null ? 0 : object.hashCode();
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Class getType() {
        return this.object.getClass();
    }

    @Override
    public MetaObjectKey getKey() {
        return new MetaObjectKey(this.getType(), String.valueOf(this.code));
    }

    public void addCompositeSetter(CompositeSlotSetter compositeSetter) {
        compositeSetter.setMetaObject(this);
        this.compositeSetters.add(compositeSetter);
    }

    protected List<CompositeSlotSetter> getCompositeSetters() {
        return this.compositeSetters;
    }

    @Override
    protected void commit() {
        for (MetaSlot slot : this.getAllSlots()) {
            if (slot.isSetterIgnored() || !slot.isCached()) continue;
            Object value = slot.getObject();
            try {
                this.setProperty(slot, value);
            }
            catch (Exception e) {
                throw new RuntimeException("could not write property '" + slot.getName() + "' in object " + this.getObject(), e);
            }
        }
        for (CompositeSlotSetter compositeSetter : this.getCompositeSetters()) {
            compositeSetter.executeSetter();
        }
    }

    protected void setProperty(MetaSlot slot, Object value) {
        RendererPropertyUtils.setProperty(this.getObject(), slot.getName(), value, false);
    }
}

