/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class StringRenderer
extends OutputRenderer {
    private boolean isLink;
    private String linkText;
    private boolean escaped;
    private boolean newlineAware;
    private Integer length;
    private boolean javascriptEnabled = false;
    private String openClasses;
    private String closedClasses;
    private String textClasses;
    private String noJavascriptClasses;

    public String getNoJavascriptClasses() {
        return this.noJavascriptClasses;
    }

    public void setNoJavascriptClasses(String noJavascriptClasses) {
        this.noJavascriptClasses = noJavascriptClasses;
    }

    public String getOpenClasses() {
        return this.openClasses;
    }

    public void setOpenClasses(String openClasses) {
        this.openClasses = openClasses;
    }

    public String getClosedClasses() {
        return this.closedClasses;
    }

    public void setClosedClasses(String closedClasses) {
        this.closedClasses = closedClasses;
    }

    public String getTextClasses() {
        return this.textClasses;
    }

    public void setTextClasses(String textClasses) {
        this.textClasses = textClasses;
    }

    public boolean isJavascriptEnabled() {
        return this.javascriptEnabled;
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.javascriptEnabled = javascriptEnabled;
    }

    public StringRenderer() {
        this.setEscaped(true);
        this.setNewlineAware(true);
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public void setEscaped(boolean escaped) {
        this.escaped = escaped;
        if (!escaped) {
            this.setNewlineAware(false);
        }
    }

    public boolean isNewlineAware() {
        return this.newlineAware;
    }

    public void setNewlineAware(boolean newlineAware) {
        this.newlineAware = newlineAware;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public void setLink(boolean makeLink) {
        this.isLink = makeLink;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                Object text;
                if (object == null) {
                    return new HtmlText();
                }
                String string = String.valueOf(object);
                if (!StringRenderer.this.isLink() || string == null) {
                    HtmlComponent component = null;
                    if (StringRenderer.this.getLength() != null && string.length() > StringRenderer.this.getLength()) {
                        component = new HtmlText(string.substring(0, StringRenderer.this.getLength()) + "...", StringRenderer.this.isEscaped(), StringRenderer.this.isNewlineAware());
                        if (!StringRenderer.this.isJavascriptEnabled()) {
                            component.setTitle(HtmlText.escape(string));
                        } else {
                            component = this.wrapUpCompletion(component, HtmlText.escape(string));
                        }
                    } else {
                        component = new HtmlText(string, StringRenderer.this.isEscaped(), StringRenderer.this.isNewlineAware());
                    }
                    return component;
                }
                HtmlContainer container = new HtmlInlineContainer();
                HtmlLink link = new HtmlLink();
                container.addChild(link);
                link.setContextRelative(false);
                Object object2 = text = StringRenderer.this.getLinkText() == null ? string : StringRenderer.this.getLinkText();
                if (StringRenderer.this.getLength() != null && ((String)text).length() > StringRenderer.this.getLength()) {
                    link.setTitle(HtmlText.escape((String)text));
                    text = ((String)text).substring(0, StringRenderer.this.getLength()) + "...";
                }
                if (!StringRenderer.this.isJavascriptEnabled()) {
                    link.setText(HtmlText.escape((String)text));
                } else {
                    container = this.wrapUpCompletion(container, HtmlText.escape(string));
                }
                if (string.matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*$")) {
                    link.setUrl("mailto:" + string);
                } else {
                    link.setUrl(string);
                }
                return container;
            }

            private HtmlContainer wrapUpCompletion(HtmlComponent component, String escape) {
                HtmlBlockContainer container = new HtmlBlockContainer();
                container.addChild(component);
                String id = HtmlComponent.getValidIdOrName(String.valueOf(escape.hashCode())) + ":" + System.currentTimeMillis();
                HtmlBlockContainer helpContainer = new HtmlBlockContainer();
                helpContainer.setClasses(StringRenderer.this.getNoJavascriptClasses());
                helpContainer.setId(id);
                component.setOnMouseOver(this.getScript(id, StringRenderer.this.getOpenClasses()));
                component.setOnMouseOut(this.getScript(id, StringRenderer.this.getClosedClasses()));
                HtmlBlockContainer textContainer = new HtmlBlockContainer();
                textContainer.setClasses(StringRenderer.this.getTextClasses());
                textContainer.addChild(new HtmlText(escape));
                helpContainer.addChild(textContainer);
                container.addChild(helpContainer);
                HtmlScript script = new HtmlScript();
                script.setContentType("text/javascript");
                script.setScript(this.getScript(id, StringRenderer.this.getClosedClasses()));
                container.addChild(script);
                return container;
            }

            private String getScript(String id, String classes) {
                return String.format("document.getElementById('%s').className='%s';", id, classes);
            }

            @Override
            public void applyStyle(HtmlComponent component) {
                component.setClasses(this.getClasses());
                component.setStyle(this.getStyle());
                if (component.getTitle() == null) {
                    component.setTitle(this.getTitle());
                }
            }
        };
    }
}

