/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.qubAccessControl.domain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.qubit.terra.qubAccessControl.domain.AccessControlPermission;
import com.qubit.terra.qubAccessControl.domain.AccessControlProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import pt.ist.fenixframework.DomainObject;

public class ObjectProfilesCache {
    private static final Cache<Object, Set<AccessControlProfile>> CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();

    public static <T extends DomainObject> Set<AccessControlProfile> hasAccess(AccessControlPermission permission, T object) {
        Set profiles = new HashSet();
        try {
            profiles = (Set)CACHE.get(object, () -> ObjectProfilesCache.loadCache(object));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return profiles.stream().filter(profile -> ObjectProfilesCache.hasPermission(profile, permission)).collect(Collectors.toSet());
    }

    private static boolean hasPermission(AccessControlProfile profile, AccessControlPermission permission) {
        if (profile.getPermissionSet().contains((Object)permission)) {
            return true;
        }
        return profile.getChildSet().stream().anyMatch(child -> ObjectProfilesCache.hasPermission(child, permission));
    }

    public static <T extends DomainObject> boolean contains(AccessControlProfile profile, T object) {
        return ObjectProfilesCache.getProfiles(object).contains((Object)profile);
    }

    public static <T extends DomainObject> Set<AccessControlProfile> getProfiles(T object) {
        HashSet<AccessControlProfile> result = new HashSet<AccessControlProfile>();
        try {
            result.addAll((Collection)CACHE.get(object, () -> ObjectProfilesCache.loadCache(object)));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static <T extends DomainObject> void addToCache(T object, AccessControlProfile profile) {
        HashSet<AccessControlProfile> cachedProfiles = (HashSet<AccessControlProfile>)CACHE.getIfPresent(object);
        if (cachedProfiles != null) {
            cachedProfiles.add(profile);
        } else {
            cachedProfiles = new HashSet<AccessControlProfile>();
            cachedProfiles.add(profile);
            CACHE.put(object, cachedProfiles);
        }
    }

    public static <T extends DomainObject> void removeFromCache(T object, AccessControlProfile profile) {
        Set cachedProfiles = (Set)CACHE.getIfPresent(object);
        if (cachedProfiles != null) {
            cachedProfiles.remove((Object)profile);
            if (cachedProfiles.isEmpty()) {
                CACHE.invalidate(object);
            }
        }
    }

    private static <T extends DomainObject> Set<AccessControlProfile> loadCache(T object) {
        return AccessControlProfile.findAll().stream().filter(profile -> object.getClass().equals(profile.getProviderClass()) && profile.containsObject(object) != false).collect(Collectors.toSet());
    }
}

