/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.qubAccessControl.domain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.qubit.terra.framework.services.ServiceProvider;
import com.qubit.terra.framework.services.accessControl.Permission;
import com.qubit.terra.framework.services.accessControl.Profile;
import com.qubit.terra.framework.services.versioning.VersioningInformationReader;
import com.qubit.terra.framework.tools.primitives.LocalizedString;
import com.qubit.terra.qubAccessControl.domain.AccessControlPermission$callable$delete;
import com.qubit.terra.qubAccessControl.domain.AccessControlPermission$callable$lookup;
import com.qubit.terra.qubAccessControl.domain.AccessControlPermission_Base;
import com.qubit.terra.qubAccessControl.servlet.AccessControlBundle;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AccessControlPermission
extends AccessControlPermission_Base
implements Permission {
    private static final Cache<String, Optional<AccessControlPermission>> CACHE;
    public static final Advice advice$lookup;
    public static final Advice advice$delete;

    protected AccessControlPermission() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected AccessControlPermission(String rawName, LocalizedString description, Boolean restricted, String code) {
        this();
        this.setRawName(rawName);
        this.setDescription(description);
        this.setRestricted(restricted);
        this.setCode(code);
        this.checkRules();
        CACHE.put((Object)code, Optional.of(this));
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.domainRoot.required"));
        }
        if (this.getRawName() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlPermission.rawName.required"));
        }
        if (this.getRestricted() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlPermission.restricted.required"));
        }
        if (this.getCode() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlPermission.code.required"));
        }
    }

    public static AccessControlPermission create(String rawName, LocalizedString description, Boolean restricted, String code) {
        if (AccessControlPermission.findByCode(code) == null) {
            return new AccessControlPermission(rawName, description, restricted, code);
        }
        throw new IllegalArgumentException(AccessControlBundle.get("error.AccessControlPermission.code.exists", code));
    }

    public static AccessControlPermission create(String rawName, Boolean restricted, String code) {
        return AccessControlPermission.create(rawName, new LocalizedString(), restricted, code);
    }

    public static AccessControlPermission findByCode(String code) {
        try {
            AccessControlPermission result = ((Optional)CACHE.get((Object)code, () -> AccessControlPermission.lookup(code))).orElse(null);
            if (result != null && FenixFramework.isDomainObjectValid((DomainObject)result)) {
                return result;
            }
            CACHE.invalidate((Object)code);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private static Optional<AccessControlPermission> lookup(String string) {
        return (Optional)advice$lookup.perform((Callable)new AccessControlPermission$callable$lookup(string));
    }

    static /* synthetic */ Optional<AccessControlPermission> advised$lookup(String code) {
        return AccessControlPermission.findAll().stream().filter(op -> op.getCode().equals(code)).findFirst();
    }

    public static Set<AccessControlPermission> findAll() {
        return FenixFramework.getDomainRoot().getPermissionsSet();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AccessControlPermission$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AccessControlPermission this_) {
        if (!this_.getProfileSet().isEmpty()) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlPermission.delete") + this_.getProfileSet().stream().map(profile -> profile.getRawName()).collect(Collectors.joining(",")));
        }
        this_.setDomainRoot(null);
        CACHE.invalidate((Object)this_.getCode());
        super.deleteDomainObject();
    }

    public String getExpression() {
        return "permission(" + this.getCode() + ")";
    }

    public boolean isRestricted() {
        return Boolean.TRUE.equals(this.getRestricted());
    }

    public boolean isAutoGenerated() {
        return Boolean.TRUE.equals(this.getAutoGenerated());
    }

    public <T extends DomainObject> Set<T> provideObjects() {
        return this.getProfileSet().stream().flatMap(profile -> profile.provideObjects().stream()).map(object -> (DomainObject)object).collect(Collectors.toSet());
    }

    public <T extends DomainObject> Set<T> provideObjects(Class<T> clazz) {
        return this.getProfileSet().stream().filter(profile -> profile.getProviderClass() != null && profile.getProviderClass().isAssignableFrom(clazz)).flatMap(profile -> profile.provideObjects().stream()).map(object -> (DomainObject)object).collect(Collectors.toSet());
    }

    public Set<Profile> getProfiles() {
        return this.getProfileSet().stream().collect(Collectors.toSet());
    }

    public void setName(LocalizedString name) {
        this.setRawName(name.toString());
    }

    public LocalizedString getName() {
        return new LocalizedString(this.getRawName());
    }

    public DateTime getCreationDate() {
        return ((VersioningInformationReader)ServiceProvider.getService(VersioningInformationReader.class)).getCreationDate((Object)this);
    }

    static {
        advice$lookup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).maximumSize(10000L).expireAfterWrite(2L, TimeUnit.HOURS).build();
    }
}

