/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.ldapclient;

import com.qubit.terra.ldapclient.AttributesMap;
import com.qubit.terra.ldapclient.QueryReply;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapClient {
    private DirContext context;
    private final String username;
    private final String password;
    private final String url;
    private String baseDomainName;
    private Executor addExecutor = new Executor(){

        @Override
        public void execute(DirContext dirContext, String contextId, Attributes attributes) {
            try {
                dirContext.modifyAttributes(contextId, 1, attributes);
            }
            catch (NamingException e) {
                throw new RuntimeException("problems while adding info to entry: " + contextId, e);
            }
        }
    };
    private Executor replaceExecutor = new Executor(){

        @Override
        public void execute(DirContext dirContext, String contextId, Attributes attributes) {
            try {
                dirContext.modifyAttributes(contextId, 2, attributes);
            }
            catch (NamingException e) {
                throw new RuntimeException("problems while replacing information in entry: " + contextId, e);
            }
        }
    };
    private Executor deleteAttributeExecutor = new Executor(){

        @Override
        public void execute(DirContext dirContext, String contextId, Attributes attributes) {
            try {
                dirContext.modifyAttributes(contextId, 3, attributes);
            }
            catch (NamingException e) {
                throw new RuntimeException("problems while deleting information in entry: " + contextId, e);
            }
        }
    };
    private Executor createExecutor = new Executor(){

        @Override
        public void execute(DirContext dirContext, String contextId, Attributes attributes) {
            try {
                dirContext.createSubcontext(contextId, attributes);
            }
            catch (NamingException e) {
                throw new RuntimeException("problems creating entry: " + contextId, e);
            }
        }
    };
    private Executor deleteExecutor = new Executor(){

        @Override
        public void execute(DirContext dirContext, String contextId, Attributes attributes) {
            try {
                dirContext.destroySubcontext(contextId);
            }
            catch (NamingException e) {
                throw new RuntimeException("problems deleting entry: " + contextId, e);
            }
        }
    };

    public LdapClient(String username, String password, String url, String baseDomainName) {
        this.username = username;
        this.password = password;
        this.url = url;
        this.baseDomainName = baseDomainName;
    }

    public QueryReply retrieveGroupMembers(String groupCommonName) {
        return this.query("(& (objectcategory=group) (cn=" + groupCommonName + "))", new String[]{"cn", "destinguishedName", "description", "member"});
    }

    public QueryReply retrieveGroupsForUser(String userCommonName) {
        return this.query("(& (objectClass=inetOrgPerson) (cn=" + userCommonName + "))", new String[]{"cn", "distinguishedName", "displayName", "mail", "memberOf"});
    }

    public QueryReply readAllUsers() {
        return this.query("(objectClass=inetOrgPerson)", new String[]{"cn", "distinguishedName", "displayName", "mail", "userpassword", "memberOf"});
    }

    public boolean isLoggedIn() {
        return this.context != null;
    }

    public void logout() {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        this.context = null;
    }

    public boolean isSecure() {
        return this.url != null && this.url.startsWith("ldaps:");
    }

    private InitialDirContext getContext(String username, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        if (this.isSecure()) {
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", "com.qubit.terra.ldapclient.LdapSocketFactory");
        }
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.read.timeout", "10000");
        try {
            InitialDirContext initialDirContext = new InitialDirContext(env);
            return initialDirContext;
        }
        catch (NamingException e) {
            return null;
        }
    }

    public boolean login() {
        this.context = this.getContext(this.username, this.password);
        return this.context != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyCredentials(String username, String password) {
        try {
            InitialDirContext context = null;
            if (username.startsWith("cn=")) {
                this.getContext(username, password);
            } else {
                context = this.getContext("cn=" + username + "," + this.baseDomainName, password);
            }
            boolean bl = context != null;
            return bl;
        }
        finally {
            if (this.context != null) {
                try {
                    this.context.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected DirContext getContext() {
        return this.context;
    }

    public QueryReply query(String searchQuery, String ... replyAttributes) {
        return this.query(this.baseDomainName, searchQuery, 2, replyAttributes);
    }

    public QueryReply query(String searchQuery, int searchScope, String ... replyAttributes) {
        return this.query(this.baseDomainName, searchQuery, searchScope, replyAttributes);
    }

    public QueryReply query(String baseDomainName, String searchQuery, String ... replyAttributes) {
        return this.query(baseDomainName, searchQuery, 2, replyAttributes);
    }

    public QueryReply query(String baseDomainName, String searchQuery, int searchScope, String ... replyAttributes) {
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(replyAttributes);
        ctls.setSearchScope(searchScope);
        QueryReply reply = new QueryReply(replyAttributes);
        try {
            NamingEnumeration<SearchResult> answer = this.context.search(this.baseDomainName, searchQuery, ctls);
            this.processResponse(reply, answer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reply;
    }

    protected void processResponse(QueryReply reply, NamingEnumeration<SearchResult> answer) throws NamingException {
        while (answer.hasMore()) {
            reply.createNewElement();
            SearchResult rslt = answer.next();
            Attributes attrs = rslt.getAttributes();
            NamingEnumeration<? extends Attribute> all = attrs.getAll();
            while (all.hasMore()) {
                Attribute next = all.next();
                NamingEnumeration<?> all2 = next.getAll();
                while (all2.hasMore()) {
                    Object next2 = all2.next();
                    reply.addAttribute(next.getID(), next2.toString());
                }
            }
        }
    }

    public void addToExistingContext(String contextId, List<String> objectClasses, AttributesMap attributesMap) {
        this.performWrite(contextId, objectClasses, attributesMap, this.addExecutor);
    }

    public void replaceInExistingContext(String contextId, List<String> objectClasses, AttributesMap attributesMap) {
        this.performWrite(contextId, objectClasses, attributesMap, this.replaceExecutor);
    }

    public void removeFromExistingContext(String contextId, AttributesMap attributesMap) {
        this.performWrite(contextId, Collections.EMPTY_LIST, attributesMap, this.deleteAttributeExecutor);
    }

    public void writeNewContext(String contextId, List<String> objectClasses, AttributesMap attributesMap) {
        this.performWrite(contextId, objectClasses, attributesMap, this.createExecutor);
    }

    public boolean renameContext(String oldContextId, String newContextId) {
        boolean renamedWorked = false;
        try {
            this.context.rename(oldContextId, newContextId);
            renamedWorked = true;
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return renamedWorked;
    }

    public void deleteContext(String contextId) {
        this.performWrite(contextId, Collections.EMPTY_LIST, new AttributesMap(), this.deleteExecutor);
    }

    private void performWrite(String contextId, List<String> objectClasses, AttributesMap attributesMap, Executor executor) {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
        for (String objectClass : objectClasses) {
            objectClassAttribute.add(objectClass);
        }
        if (!objectClasses.isEmpty()) {
            attributes.put(objectClassAttribute);
        }
        Set<Map.Entry<String, List<String>>> entrySet = attributesMap.getMap().entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            BasicAttribute attribute = new BasicAttribute(entry.getKey());
            for (String value : entry.getValue()) {
                if (value == null) continue;
                attribute.add(value);
            }
            attributes.put(attribute);
        }
        executor.execute(this.context, contextId, attributes);
    }

    private static interface Executor {
        public void execute(DirContext var1, String var2, Attributes var3);
    }
}

