/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.santandersdk.dto;

import org.datacontract.schemas._2004._07.sibscards_wcf_services.TUIResponseData;

public class CreateRegisterResponse {
    private ErrorType errorType;
    private String responseLine;
    private String errorDescription;

    public CreateRegisterResponse(ErrorType errorType, String responseLine, String errorDescription) {
        this.setErrorType(errorType);
        this.setResponseLine(responseLine);
        this.setErrorDescription(errorDescription);
    }

    public CreateRegisterResponse(TUIResponseData response) {
        String status = response.getStatus() == null || response.getStatus() == null ? "" : response.getStatus().trim();
        ErrorType errorType = !status.isEmpty() && !status.equalsIgnoreCase("error") ? null : ErrorType.REQUEST_REFUSED;
        this.setErrorType(errorType);
        if (response.getTuiResponseLine() != null) {
            this.setResponseLine(response.getTuiResponseLine());
        }
        if (errorType != null && response.getStatusDescription() != null) {
            this.setErrorDescription(response.getStatusDescription());
        }
    }

    public CreateRegisterResponse() {
    }

    public boolean wasRegisterSuccessful() {
        return this.errorType == null;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getResponseLine() {
        return this.responseLine;
    }

    public void setResponseLine(String responseLine) {
        this.responseLine = responseLine;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public static enum ErrorType {
        SANTANDER_COMMUNICATION("santander.sdk.error.communication.with.santander"),
        REQUEST_REFUSED("santander.sdk.error.request.refused");

        public String errorMessage;

        private ErrorType(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

