/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.santandersdk.dto;

import com.google.common.base.Strings;
import org.datacontract.schemas._2004._07.sibscards_wcf_services.RegisterData;
import org.fenixedu.santandersdk.dto.GetRegisterStatus;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class GetRegisterResponse {
    private GetRegisterStatus status;
    private DateTime expiryDate;
    private DateTime expeditionDate;
    private String mifare;
    private String serialNumber;

    public GetRegisterResponse(RegisterData registerData) {
        String expeditionDateString;
        String expiryDateString;
        String status;
        String statusElement = registerData.getStatus();
        String string = status = statusElement != null ? statusElement : null;
        if (status == null) {
            status = registerData.getStatusDescription();
        }
        this.status = GetRegisterStatus.fromString(status);
        DateTime expiryDate = null;
        if (registerData.getExpiryDate() != null && (expiryDateString = registerData.getExpiryDate()) != null) {
            expiryDate = DateTime.parse((String)expiryDateString, (DateTimeFormatter)DateTimeFormat.forPattern((String)"dd-MM-yyyy"));
        }
        this.expiryDate = expiryDate;
        DateTime expeditionDate = null;
        if (registerData.getExpeditionDate() != null && (expeditionDateString = registerData.getExpeditionDate()) != null) {
            expeditionDate = DateTime.parse((String)expeditionDateString, (DateTimeFormatter)DateTimeFormat.forPattern((String)"dd-MM-yyyy"));
        }
        this.expeditionDate = expeditionDate;
        this.mifare = registerData.getMifareNumber() == null || Strings.isNullOrEmpty((String)registerData.getMifareNumber()) ? null : registerData.getMifareNumber();
        this.serialNumber = registerData.getSerialNumber() == null || Strings.isNullOrEmpty((String)registerData.getSerialNumber()) ? null : registerData.getSerialNumber();
    }

    public GetRegisterResponse() {
    }

    public GetRegisterStatus getStatus() {
        return this.status;
    }

    public void setStatus(GetRegisterStatus status) {
        this.status = status;
    }

    public DateTime getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(DateTime expiryDate) {
        this.expiryDate = expiryDate;
    }

    public DateTime getExpeditionDate() {
        return this.expeditionDate;
    }

    public void setExpeditionDate(DateTime expeditionDate) {
        this.expeditionDate = expeditionDate;
    }

    public String getMifare() {
        return this.mifare;
    }

    public void setMifare(String mifare) {
        this.mifare = mifare;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }
}

