/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.santandersdk.service;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.santandersdk.exception.SantanderValidationException;

public class SantanderEntryValidator {
    private final List<SantanderFieldValidator> validators = new ArrayList<SantanderFieldValidator>(){
        {
            this.add(new SantanderFieldValidator("record_type", true, 1, true));
            this.add(new SantanderFieldValidator("id_number", false, 10, true));
            this.add(new SantanderFieldValidator("first_name", false, 15, true));
            this.add(new SantanderFieldValidator("surname", false, 15, true));
            this.add(new SantanderFieldValidator("middle_names", false, 40, false));
            this.add(new SantanderFieldValidator("address_1", false, 50, true));
            this.add(new SantanderFieldValidator("address_2", false, 50, false));
            this.add(new SantanderFieldValidator("zip_code", false, 8, true));
            this.add(new SantanderFieldValidator("town", false, 30, true));
            this.add(new SantanderFieldValidator("home_country", false, 10, false));
            this.add(new SantanderFieldValidator("residence_country", false, 10, true));
            this.add(new SantanderFieldValidator("expire_date", false, 9, false));
            this.add(new SantanderFieldValidator("degree_code", false, 16, false));
            this.add(new SantanderFieldValidator("back_number", true, 10, true));
            this.add(new SantanderFieldValidator("curricular_year", true, 2, false));
            this.add(new SantanderFieldValidator("execution_year", true, 8, false));
            this.add(new SantanderFieldValidator("unit", false, 30, false));
            this.add(new SantanderFieldValidator("access_control", false, 10, false));
            this.add(new SantanderFieldValidator("expire_date", false, 4, true));
            this.add(new SantanderFieldValidator("template_code", false, 10, false));
            this.add(new SantanderFieldValidator("action_code", false, 4, true));
            this.add(new SantanderFieldValidator("role_code", true, 2, true));
            this.add(new SantanderFieldValidator("role_desc", false, 20, false));
            this.add(new SantanderFieldValidator("id_document_type", true, 1, true));
            this.add(new SantanderFieldValidator("check_digit", true, 1, false));
            this.add(new SantanderFieldValidator("card_type", false, 2, true));
            this.add(new SantanderFieldValidator("expedition_code", false, 2, true));
            this.add(new SantanderFieldValidator("detour_address_1", false, 50, false));
            this.add(new SantanderFieldValidator("detour_address_2", false, 50, false));
            this.add(new SantanderFieldValidator("detour_address_3", false, 50, false));
            this.add(new SantanderFieldValidator("detour_zip_code", false, 8, false));
            this.add(new SantanderFieldValidator("detour_town", false, 30, false));
            this.add(new SantanderFieldValidator("additional_data", true, 1, true));
            this.add(new SantanderFieldValidator("card_name", false, 40, false));
            this.add(new SantanderFieldValidator("email", false, 100, false));
            this.add(new SantanderFieldValidator("phone", false, 20, false));
            this.add(new SantanderFieldValidator("photo_flag", true, 1, false));
            this.add(new SantanderFieldValidator("photo_ref", false, 32, false));
            this.add(new SantanderFieldValidator("signature_flag", true, 1, false));
            this.add(new SantanderFieldValidator("signature_ref", false, 32, false));
            this.add(new SantanderFieldValidator("dig_certificate_flag", true, 1, false));
            this.add(new SantanderFieldValidator("dig_certificate_ref", false, 32, false));
            this.add(new SantanderFieldValidator("filler", false, 681, false));
            this.add(new SantanderFieldValidator("end_flag", false, 1, true));
        }
    };

    public String generateLine(List<String> values) throws SantanderValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder strBuilder = new StringBuilder(1500);
        int i = 0;
        for (String value : values) {
            try {
                strBuilder.append(this.makeStringBlock(value, this.validators.get(i)));
            }
            catch (SantanderValidationException sve) {
                errors.add(sve.getMessage());
            }
            ++i;
        }
        if (!errors.isEmpty()) {
            String errorsMessage = Joiner.on((String)"\n").join(errors);
            throw new SantanderValidationException(errorsMessage);
        }
        return strBuilder.toString();
    }

    public JsonObject getRequestAsJson(String line) {
        JsonObject result = new JsonObject();
        int offset = 0;
        for (SantanderFieldValidator validator : this.validators) {
            result.addProperty(validator.getFieldName(), this.getValue(line, offset).trim());
            ++offset;
        }
        return result;
    }

    private String makeStringBlock(String value, SantanderFieldValidator validator) throws SantanderValidationException {
        validator.validate(value);
        int size = validator.getSize();
        int fillerLength = size - value.length();
        StringBuilder blockBuilder = new StringBuilder(size);
        blockBuilder.append(value);
        for (int i = 0; i < fillerLength; ++i) {
            blockBuilder.append(" ");
        }
        return blockBuilder.toString();
    }

    public String getValue(String line, int fieldIndex) {
        int i;
        int beginIndex = 0;
        for (i = 0; i < fieldIndex; ++i) {
            SantanderFieldValidator validator = this.validators.get(i);
            beginIndex += validator.getSize();
        }
        int endIndex = this.validators.get(i).getSize() + beginIndex;
        return line.substring(beginIndex, endIndex).trim();
    }

    private static class SantanderFieldValidator {
        private final boolean required;
        private final boolean numeric;
        private final int size;
        private final String fieldName;

        public SantanderFieldValidator(String fieldName, boolean numeric, int size, boolean required) {
            this.fieldName = fieldName;
            this.numeric = numeric;
            this.size = size;
            this.required = required;
        }

        public void validate(String s) throws SantanderValidationException {
            if (Strings.isNullOrEmpty((String)s)) {
                if (this.isRequired()) {
                    throw new SantanderValidationException("property " + this.fieldName + " is missing");
                }
                return;
            }
            if (s.length() > this.size) {
                String error = String.format("property %s (%s) has to many characters (max characters: %d)", this.fieldName, s, this.size);
                throw new SantanderValidationException(error);
            }
            if (this.isNumeric() && !StringUtils.isNumeric((String)s)) {
                String error = String.format("property %s (%s) can only contain numbers", this.fieldName, s);
                throw new SantanderValidationException(error);
            }
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public int getSize() {
            return this.size;
        }
    }
}

