/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.santandersdk.dto;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.fenixedu.santandersdk.dto.PickupAddress;
import org.fenixedu.santandersdk.dto.RegisterAction;
import org.imgscalr.Scalr;

public class CreateRegisterRequest {
    private String username;
    private String cardName;
    private String fullName;
    private String role;
    private String campus;
    private String departmentAcronym;
    private byte[] photo;
    private RegisterAction action;
    private PickupAddress pickupAddress;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCardName() {
        return this.cardName;
    }

    public void setCardName(String cardName) {
        this.cardName = cardName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getCampus() {
        return this.campus;
    }

    public void setCampus(String campus) {
        this.campus = campus;
    }

    public String getDepartmentAcronym() {
        return this.departmentAcronym;
    }

    public void setDepartmentAcronym(String departmentAcronym) {
        this.departmentAcronym = departmentAcronym;
    }

    public byte[] getPhoto() {
        return this.photo;
    }

    public void setPhoto(BufferedImage photo) {
        if (photo != null) {
            this.photo = this.transform(photo);
        }
    }

    public RegisterAction getAction() {
        return this.action;
    }

    public void setAction(RegisterAction action) {
        this.action = action;
    }

    public PickupAddress getPickupAddress() {
        return this.pickupAddress;
    }

    public void setPickupAddress(PickupAddress pickupAddress) {
        this.pickupAddress = pickupAddress;
    }

    private byte[] transform(BufferedImage image) {
        BufferedImage adjustedImage = this.transformZoom(CreateRegisterRequest.dropAlphaChannel(image), 9, 10);
        BufferedImage avatar = Scalr.resize((BufferedImage)adjustedImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)180, (int)200, (BufferedImageOp[])new BufferedImageOp[0]);
        return this.writeImageAsBytes(avatar);
    }

    public static BufferedImage dropAlphaChannel(BufferedImage src) {
        if (src.getColorModel().hasAlpha()) {
            BufferedImage convertedImg = new BufferedImage(src.getWidth(), src.getHeight(), 1);
            convertedImg.getGraphics().drawImage(src, 0, 0, null);
            return convertedImg;
        }
        return src;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    private BufferedImage transformZoom(BufferedImage source, int xRatio, int yRatio) {
        BufferedImage finale;
        if (1.0 * (double)source.getWidth() / (double)source.getHeight() > 1.0 * (double)xRatio / (double)yRatio) {
            int destH = source.getHeight();
            int destW = (int)Math.round((double)(destH * xRatio) * 1.0 / ((double)yRatio * 1.0));
            int padding = (int)Math.round((double)(source.getWidth() - destW) / 2.0);
            finale = Scalr.crop((BufferedImage)source, (int)padding, (int)0, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
        } else {
            int destW = source.getWidth();
            int destH = (int)Math.round((double)(destW * yRatio) * 1.0 / ((double)xRatio * 1.0));
            int padding = (int)Math.round((double)(source.getHeight() - destH) / 2.0);
            finale = Scalr.crop((BufferedImage)source, (int)0, (int)padding, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        return finale;
    }

    private byte[] writeImageAsBytes(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "jpg", out);
            return out.toByteArray();
        }
        catch (IOException ignored) {
            throw new RuntimeException("Failed transforming image into bytearray");
        }
    }
}

