/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.santandersdk.service;

import javax.xml.ws.WebServiceException;
import org.datacontract.schemas._2004._07.sibscards_wcf_services.RegisterData;
import org.datacontract.schemas._2004._07.sibscards_wcf_services.TUIResponseData;
import org.datacontract.schemas._2004._07.sibscards_wcf_services.TuiPhotoRegisterData;
import org.datacontract.schemas._2004._07.sibscards_wcf_services.TuiSignatureRegisterData;
import org.fenixedu.santandersdk.dto.CardPreviewBean;
import org.fenixedu.santandersdk.dto.CreateRegisterRequest;
import org.fenixedu.santandersdk.dto.CreateRegisterResponse;
import org.fenixedu.santandersdk.dto.GetRegisterResponse;
import org.fenixedu.santandersdk.exception.SantanderValidationException;
import org.fenixedu.santandersdk.service.RegisterInfoWebServiceClient;
import org.fenixedu.santandersdk.service.SantanderEntryValidator;
import org.fenixedu.santandersdk.service.SantanderLineGenerator;
import org.fenixedu.santandersdk.service.TuiWebserviceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sibscartoes.portal.wcf.IRegisterInfoService;
import pt.sibscartoes.portal.wcf.ITUIDetailService;

public class SantanderSdkService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SantanderSdkService.class);
    private SantanderLineGenerator santanderLineGenerator = new SantanderLineGenerator(new SantanderEntryValidator());

    public GetRegisterResponse getRegister(String userName) {
        RegisterInfoWebServiceClient client = new RegisterInfoWebServiceClient();
        IRegisterInfoService port = client.getRegisterService();
        RegisterData registerData = port.getRegister(userName);
        return new GetRegisterResponse(registerData);
    }

    public CardPreviewBean generateCardRequest(CreateRegisterRequest request) throws SantanderValidationException {
        return this.santanderLineGenerator.generateLine(request);
    }

    public CreateRegisterResponse createRegister(CardPreviewBean cardPreviewBean) {
        String tuiEntry = cardPreviewBean.getRequestLine();
        TuiPhotoRegisterData photoRegisterData = this.createPhoto(cardPreviewBean.getPhoto());
        TuiSignatureRegisterData signature = new TuiSignatureRegisterData();
        TuiWebserviceClient client = new TuiWebserviceClient();
        ITUIDetailService port = client.getTuiDetailService();
        try {
            TUIResponseData responseData = port.saveRegister(tuiEntry, photoRegisterData, signature);
            return new CreateRegisterResponse(responseData);
        }
        catch (WebServiceException e) {
            LOGGER.error(String.format("An webservice error happened while trying to create santander register. -> %s", e.getMessage()), (Throwable)e);
            return new CreateRegisterResponse(CreateRegisterResponse.ErrorType.SANTANDER_COMMUNICATION, "santander communication error", e.getMessage());
        }
    }

    private TuiPhotoRegisterData createPhoto(byte[] photoContents) {
        String EXTENSION = ".jpeg";
        TuiPhotoRegisterData photo = new TuiPhotoRegisterData();
        photo.setFileContents(photoContents);
        photo.setSize(String.valueOf(photoContents.length));
        photo.setExtension(".jpeg");
        photo.setFileName("foto");
        return photo;
    }
}

