/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.ulisboa.mavenPlugins;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="jaxws-merger", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class SunJaxWSMerger
extends AbstractMojo {
    @Parameter(property="project")
    protected MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.mavenProject.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Project is pom type. Skipping less generation");
            return;
        }
        Set artifacts = this.mavenProject.getDependencyArtifacts();
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        Document resultDocument = documentBuilder.newDocument();
        Element rootElement = resultDocument.createElement("endpoints");
        resultDocument.appendChild(rootElement);
        rootElement.setAttribute("xmlns", "http://java.sun.com/xml/ns/jax-ws/ri/runtime");
        rootElement.setAttribute("version", "2.0");
        for (Artifact artifact : artifacts) {
            File file;
            if (!artifact.getType().equals("jar") || (file = artifact.getFile()) == null) continue;
            try (JarFile jarFile = new JarFile(file);){
                ZipEntry entry = jarFile.getEntry("META-INF/resources/WEB-INF/sun-jaxws-fragment.xml");
                if (entry == null) continue;
                Document doc = documentBuilder.parse(jarFile.getInputStream(entry));
                doc.getDocumentElement().normalize();
                NodeList list = doc.getElementsByTagName("endpoint");
                for (int i = 0; i < list.getLength(); ++i) {
                    Element handlerChain;
                    Element handlerChains;
                    Node cloneNode = list.item(i).cloneNode(true);
                    resultDocument.adoptNode(cloneNode);
                    rootElement.appendChild(cloneNode);
                    if (this.findChildElement(cloneNode, "handler-chains") == null) {
                        handlerChains = resultDocument.createElement("handler-chains");
                        cloneNode.appendChild(handlerChains);
                        handlerChains.setAttribute("xmlns", "http://java.sun.com/xml/ns/javaee");
                    }
                    if (this.findChildElement(handlerChains = this.findChildElement(cloneNode, "handler-chains"), "handler-chain") == null) {
                        handlerChain = resultDocument.createElement("handler-chain");
                        handlerChains.appendChild(handlerChain);
                    }
                    handlerChain = this.findChildElement(handlerChains, "handler-chain");
                    Element handler = resultDocument.createElement("handler");
                    handlerChain.appendChild(handler);
                    Element handlerName = resultDocument.createElement("handler-name");
                    handler.appendChild(handlerName);
                    handlerName.setTextContent("SecurityHandler");
                    Element handlerClass = resultDocument.createElement("handler-class");
                    handler.appendChild(handlerClass);
                    handlerClass.setTextContent("com.qubit.solution.fenixedu.bennu.webservices.services.server.BennuWebServiceHandler");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        try {
            File directory = new File(this.mavenProject.getBasedir() + File.separator + "src" + File.separator + "main" + File.separator + "webapp" + File.separator + "WEB-INF");
            directory.mkdirs();
            File file = new File(directory, "sun-jaxws.xml");
            file.createNewFile();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(resultDocument);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private Element findChildElement(Node node, String elementName) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!elementName.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }
}

