/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.bennu_label_overrider;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="bennu-label-overrider-mojo", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BennuLabelOverriderMojo
extends AbstractMojo {
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String SPRING_RESOURCES = "META-INF/resources/WEB-INF/resources/";
    private static final String RESOURCES = "resources";
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Parameter(property="project")
    protected MavenProject mavenProject;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> remoteRepos;
    Map<String, DependencyNodeBean> nodes = new HashMap<String, DependencyNodeBean>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.mavenProject.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Project is pom type. Skipping resources override.");
            return;
        }
        String artifactCoords = this.mavenProject.getGroupId() + ":" + this.mavenProject.getArtifactId() + ":" + this.mavenProject.getVersion();
        this.logger.info("Overriding Labels");
        String realPath = this.mavenProject.getBasedir().toPath().toString() + "/src/main/webapp/";
        List<DependencyNodeBean> topologicalSort = null;
        try {
            Dependency dependency = new Dependency((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(artifactCoords), "runtime");
            CollectResult collectDependencies = this.collectDependencies(dependency);
            this.visit(collectDependencies.getRoot());
            topologicalSort = this.topologicalSort();
        }
        catch (DependencyCollectionException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to extract labels");
        }
        Map artifactMap = this.mavenProject.getArtifactMap();
        Collections.reverse(topologicalSort);
        topologicalSort.stream().map(x -> (Artifact)artifactMap.get(x.getId())).filter(x -> x != null && x.getType().equals("jar")).map(x -> x.getFile()).forEach(file -> this.extractProperties((File)file, realPath));
    }

    private CollectResult collectDependencies(Dependency dependency) throws DependencyCollectionException {
        return this.repoSystem.collectDependencies(this.repoSession, new CollectRequest(dependency, this.remoteRepos));
    }

    private List<DependencyNodeBean> topologicalSort() {
        ArrayList<DependencyNodeBean> sortedNodes = new ArrayList<DependencyNodeBean>();
        while (!this.nodes.isEmpty()) {
            boolean hadChanges = false;
            block1: for (DependencyNodeBean node : new HashSet<DependencyNodeBean>(this.nodes.values())) {
                for (String dependedBy : node.getDependendBy()) {
                    if (!this.nodes.containsKey(dependedBy)) continue;
                    continue block1;
                }
                sortedNodes.add(node);
                this.nodes.remove(node.getId());
                hadChanges = true;
            }
            if (hadChanges) continue;
            return sortedNodes;
        }
        return sortedNodes;
    }

    private DependencyNodeBean visit(DependencyNode dependency) throws DependencyCollectionException {
        org.eclipse.aether.artifact.Artifact artifact = dependency.getArtifact();
        String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
        DependencyNodeBean dependencyNodeBean = this.nodes.get(id);
        if (dependencyNodeBean == null) {
            dependencyNodeBean = new DependencyNodeBean(id);
            this.nodes.put(dependencyNodeBean.getId(), dependencyNodeBean);
        }
        for (DependencyNode node : dependency.getChildren()) {
            DependencyNodeBean visit = this.nodes.get(node.getArtifact().getGroupId() + ":" + node.getArtifact().getArtifactId());
            if (visit == null) {
                CollectResult collectDependencies = this.collectDependencies(node.getDependency());
                visit = this.visit(collectDependencies.getRoot());
            }
            visit.getDependendBy().add(dependencyNodeBean.getId());
            if (dependencyNodeBean.getDependencies().containsKey(visit.getId())) continue;
            dependencyNodeBean.getDependencies().put(visit.getId(), visit);
        }
        return dependencyNodeBean;
    }

    private void extractProperties(File file, String realPath) {
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry nextElement = entries.nextElement();
                String name = nextElement.getName();
                if (!name.startsWith(RESOURCES) && !name.startsWith(SPRING_RESOURCES) || !name.endsWith(PROPERTIES_EXTENSION)) continue;
                this.extractProperties(jarFile, nextElement, realPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to operate with jar " + file, e);
        }
    }

    private void extractProperties(JarFile jarFile, JarEntry nextElement, String realPath) throws IOException {
        this.logger.debug("extracting " + nextElement + " from " + jarFile.getName());
        String realName = nextElement.getName();
        String encoding = realName.startsWith("META-INF/resources") ? "UTF-8" : "ISO-8859-1";
        realName = realName.startsWith("META-INF/resources") ? realName.replace("META-INF/resources", "") : "WEB-INF/classes/" + realName;
        File tmpFile = new File(realPath + realName + ".tmp");
        tmpFile.getParentFile().mkdirs();
        File finalFile = new File(realPath + realName);
        HashSet<String> foundKeys = new HashSet<String>();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), Charset.forName(encoding)));
        BufferedReader jarPropertiesReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(nextElement), Charset.forName(encoding)));
        String readLine = null;
        while ((readLine = jarPropertiesReader.readLine()) != null) {
            int indexOf = readLine.indexOf("=");
            if (indexOf > -1) {
                String trimmedKey = readLine.substring(0, indexOf).trim();
                foundKeys.add(trimmedKey);
            }
            bufferedWriter.write(readLine);
            bufferedWriter.newLine();
        }
        if (finalFile.exists()) {
            BufferedReader finalFileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(finalFile), Charset.forName(encoding)));
            while ((readLine = finalFileReader.readLine()) != null) {
                String trimmedKey;
                int indexOf = readLine.indexOf("=");
                if (indexOf > -1 && foundKeys.contains(trimmedKey = readLine.substring(0, indexOf).trim())) continue;
                bufferedWriter.write(readLine);
                bufferedWriter.newLine();
            }
            finalFileReader.close();
        }
        bufferedWriter.close();
        jarPropertiesReader.close();
        Files.copy(tmpFile.toPath(), finalFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.delete(tmpFile.toPath());
    }

    URL calculateJarURL(URL dmlUrl) {
        int lastIndexOf = dmlUrl.toString().lastIndexOf("!");
        try {
            String substring = dmlUrl.toString().substring(4, lastIndexOf);
            return new URL(substring);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to calculate jarname for dml file " + dmlUrl, e);
        }
    }

    class DependencyNodeBean {
        String id;
        Map<String, DependencyNodeBean> dependencies;
        Set<String> dependendBy = new HashSet<String>();

        public DependencyNodeBean(String id) {
            this.id = id;
            this.dependencies = new HashMap<String, DependencyNodeBean>();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Map<String, DependencyNodeBean> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Map<String, DependencyNodeBean> dependencies) {
            this.dependencies = dependencies;
        }

        public Set<String> getDependendBy() {
            return this.dependendBy;
        }

        public void setDependendBy(Set<String> dependendBy) {
            this.dependendBy = dependendBy;
        }
    }
}

