/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.geographic;

import pt.ist.standards.geographic.Municipality;
import pt.ist.standards.geographic.Planet;

public class Parish {
    private static final long serialVersionUID = 1L;
    public final Municipality municipality;
    public final String name;
    public final String code;
    private static final char PLACE_SEPERATOR = ';';

    public Parish(Municipality municipality, String name, String code) {
        this.municipality = municipality;
        this.name = name;
        this.code = code;
        municipality.addParish(this);
    }

    public String exportAsString() {
        StringBuilder result = new StringBuilder();
        if (this.municipality != null) {
            this.municipality.exportAsString(result);
        }
        result.append(';');
        result.append(this.code);
        return result.toString();
    }

    public static Parish importParishFromString(String string) {
        int i = string.lastIndexOf(59);
        String municipalityKey = string.substring(0, i);
        Municipality municipality = (Municipality)Planet.importPlaceFromString(municipalityKey);
        String parishKey = string.substring(i + 1);
        return municipality.getParish(parishKey);
    }
}

