/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.geographic;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class Place<P extends Place<?, ? extends Place<P, C>>, C extends Place<? extends Place<P, C>, ?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final P parent;
    public final String name;
    private final Map<String, C> containedPlaces = new HashMap<String, C>();
    private final String[] keys;
    private static final char KEY_SEPERATOR = ':';
    private static final char PLACE_SEPERATOR = ';';

    public Place(P parent, String name, String ... keys) {
        this.parent = parent;
        this.name = name;
        this.keys = Arrays.copyOf(keys, keys.length);
        for (String key : keys) {
            if (key.trim().length() <= 0) continue;
            ((Place)parent).addPlace(key, this);
        }
    }

    void addPlace(String key, Place place) {
        this.containedPlaces.put(key, place);
    }

    public C getPlace(String key) {
        return (C)((Place)this.containedPlaces.get(key));
    }

    public Set<C> getPlaces() {
        Collection<C> places = this.containedPlaces.values();
        return new HashSet<C>(places);
    }

    public String exportAsString() {
        StringBuilder result = new StringBuilder();
        this.exportAsString(result);
        return result.toString();
    }

    void exportAsString(StringBuilder result) {
        if (this.parent != null) {
            ((Place)this.parent).exportAsString(result);
        }
        if (result.length() > 0) {
            result.append(';');
        }
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            if (i > 0) {
                result.append(':');
            }
            result.append(key);
        }
    }

    Place importFrom(String string) {
        return this.importFrom(string, 0);
    }

    Place importFrom(String string, int i) {
        if (i == string.length()) {
            return this;
        }
        int ksp = string.indexOf(58, i);
        int psp = string.indexOf(59, i);
        int sp = ksp > i && (ksp < psp || psp < 0) ? ksp : (psp < 0 ? string.length() : psp);
        String key = string.substring(i, sp);
        C place = this.getPlace(key);
        int nexti = psp < i ? string.length() : psp + 1;
        return ((Place)place).importFrom(string, nexti);
    }

    public String getLocalizedName(Locale locale) {
        return this.name;
    }
}

