/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.geographic;

import pt.ist.standards.geographic.Country;
import pt.ist.standards.geographic.District;
import pt.ist.standards.geographic.Locality;
import pt.ist.standards.geographic.Municipality;
import pt.ist.standards.geographic.Parish;
import pt.ist.standards.geographic.Planet;
import pt.ist.standards.geographic.PostalCode;
import pt.ist.standards.util.ResourceReader;

class DataLoader {
    private static final String RESOURCE_PATH = "/geographic/";

    DataLoader() {
    }

    static Planet init() {
        Planet planet = new Planet("Earth");
        DataLoader.loadCountryData(planet);
        DataLoader.loadSpecificCountryDate(planet);
        return planet;
    }

    private static void loadCountryData(Planet planet) {
        String[] content;
        for (String line : content = ResourceReader.readLines("/geographic/countries.txt", "ISO-8859-1")) {
            String[] ss = line.split("\t");
            String alpha2 = ss[0];
            String alpha3 = ss[1];
            String number = ss[2];
            String name = ss[3];
            new Country(planet, name, alpha2, alpha3, number);
        }
    }

    private static void loadSpecificCountryDate(Planet planet) {
        DataLoader.loadSpecificCountryDate(planet, "PRT");
    }

    private static void loadSpecificCountryDate(Planet planet, String alfa3) {
        Country country = (Country)planet.getPlace(alfa3);
        String resourcePrefix = RESOURCE_PATH + alfa3.toLowerCase();
        DataLoader.loadDistricts(country, resourcePrefix);
        DataLoader.loadMunicipalities(country, resourcePrefix);
        DataLoader.loadPostalCodes(country, resourcePrefix);
        DataLoader.loadParishes(country, resourcePrefix);
    }

    private static void loadDistricts(Country country, String resourcePrefix) {
        String[] content = ResourceReader.readLines(resourcePrefix + "/districts.txt", "ISO-8859-1");
        int i = content.length;
        while (i-- > 0) {
            String line = content[i];
            int s = line.indexOf(59);
            if (s <= 0) continue;
            String code = line.substring(0, s).trim();
            String name = line.substring(s + 1).trim();
            new District(country, name, code);
        }
    }

    private static void loadMunicipalities(Country country, String resourcePrefix) {
        String[] content;
        for (String line : content = ResourceReader.readLines(resourcePrefix + "/municipalities.txt", "ISO-8859-1")) {
            int s1 = line.indexOf(59);
            int s2 = line.indexOf(59, s1 + 1);
            if (s2 <= 0) continue;
            String districtKey = line.substring(0, s1).trim();
            String code = line.substring(s1 + 1, s2).trim();
            String name = line.substring(s2 + 1).trim();
            District district = (District)country.getPlace(districtKey);
            new Municipality(district, name, code);
        }
    }

    private static void loadPostalCodes(Country country, String resourcePrefix) {
        String[] content;
        for (String line : content = ResourceReader.readLines(resourcePrefix + "/postalCodes.txt", "ISO-8859-1")) {
            String streetName;
            PostalCode postalCode;
            int s1 = line.indexOf(59);
            int s2 = line.indexOf(59, s1 + 1);
            int s3 = line.indexOf(59, s2 + 1);
            int s4 = line.indexOf(59, s3 + 1);
            int s5 = line.indexOf(59, s4 + 1);
            int s6 = line.indexOf(59, s5 + 1);
            int s7 = line.indexOf(59, s6 + 1);
            int s8 = line.indexOf(59, s7 + 1);
            int s9 = line.indexOf(59, s8 + 1);
            int s10 = line.indexOf(59, s9 + 1);
            int s11 = line.indexOf(59, s10 + 1);
            int s12 = line.indexOf(59, s11 + 1);
            int s13 = line.indexOf(59, s12 + 1);
            int s14 = line.indexOf(59, s13 + 1);
            int s15 = line.indexOf(59, s14 + 1);
            int s16 = line.indexOf(59, s15 + 1);
            String districtKey = line.substring(0, s1).trim();
            String municipalityKey = line.substring(s1 + 1, s2).trim();
            String localityKey = line.substring(s2 + 1, s3).trim();
            String localityName = line.substring(s3 + 1, s4).trim();
            String postalCodeKey = line.substring(s14 + 1, s15).trim();
            String extension = line.substring(s15 + 1, s16).trim();
            String vCodigoPostal = postalCodeKey + "-" + extension;
            String postalCodeName = line.substring(s16 + 1).trim();
            District district = (District)country.getPlace(districtKey);
            Municipality municipality = (Municipality)district.getPlace(municipalityKey);
            Locality locality = (Locality)municipality.getPlace(localityKey);
            if (locality == null) {
                locality = new Locality(municipality, localityName, localityKey);
            }
            if ((postalCode = (PostalCode)locality.getPlace(vCodigoPostal)) == null) {
                postalCode = new PostalCode(locality, postalCodeName, vCodigoPostal);
            }
            if ((streetName = line.substring(s5 + 1, s10).replace(';', ' ').replaceAll("( )+", " ").trim()).isEmpty()) continue;
            postalCode.streets.add(streetName);
        }
    }

    private static void loadParishes(Country country, String resourcePrefix) {
        String[] content;
        for (String line : content = ResourceReader.readLines(resourcePrefix + "/parishes.txt", "ISO-8859-1")) {
            int s1 = line.indexOf(59);
            int s2 = line.indexOf(59, s1 + 1);
            int s3 = line.indexOf(59, s2 + 1);
            int s4 = line.indexOf(59, s3 + 1);
            int s5 = line.indexOf(59, s4 + 1);
            int s6 = line.indexOf(59, s5 + 1);
            String districtKey = line.substring(s1 + 1, s2);
            String municipalityKey = line.substring(s3 + 1, s4);
            String parishKey = line.substring(s5 + 1, s6);
            String parishName = line.substring(s6 + 1);
            District district = (District)country.getPlace(districtKey);
            if (district == null) {
                System.out.println("no district for: " + districtKey);
                continue;
            }
            Municipality municipality = (Municipality)district.getPlace(municipalityKey);
            if (municipality == null) {
                System.out.println("no municipality for: " + districtKey + " " + municipalityKey);
                continue;
            }
            new Parish(municipality, parishName, parishKey);
        }
    }
}

