/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ResourceReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readLines(String resource, String encoding) {
        InputStream inputStream = ResourceReader.class.getResourceAsStream(resource);
        try {
            InputStreamReader fileReader = new InputStreamReader(inputStream, encoding);
            try {
                char[] buffer = new char[4096];
                StringBuilder fileContents = new StringBuilder();
                int n = 0;
                while ((n = fileReader.read(buffer)) != -1) {
                    fileContents.append(buffer, 0, n);
                }
                String[] stringArray = fileContents.toString().split("\n");
                return stringArray;
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
            finally {
                try {
                    fileReader.close();
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String[] readLines(String resource) {
        return ResourceReader.readLines(resource, "UTF-8");
    }
}

