/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.geographic;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import pt.ist.standards.geographic.District;
import pt.ist.standards.geographic.Place;
import pt.ist.standards.geographic.Planet;
import pt.ist.standards.geographic.PostalCode;

public class Country
extends Place<Planet, District> {
    private static final long serialVersionUID = 1L;
    public final String alpha2;
    public final String alpha3;
    public final String number;
    final Map<String, PostalCode> postalCodeMap = new HashMap<String, PostalCode>();

    public Country(Planet planet, String name, String alpha2, String alpha3, String number) {
        super(planet, name, alpha2, alpha3, number);
        this.alpha2 = alpha2;
        this.alpha3 = alpha3;
        this.number = number;
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return this.getResource("geographic.CountryResources", locale);
    }

    public String getNationality(Locale locale) {
        return this.getResource("geographic.NationalityResources", locale);
    }

    private String getResource(String bundleName, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, locale);
        return resourceBundle.getString(this.alpha3);
    }

    public PostalCode getPostalCode(String code) {
        return this.postalCodeMap.get(code);
    }
}

