/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.onlinepaymentsgateway.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class Decryption {
    public static final int GCM_TAG_LENGTH = 16;
    private String iv;
    private String aesKey;
    private String authTag;
    private String payload;

    public Decryption(String aesKey, String iv, String authTag, String payload) {
        this.iv = iv;
        this.aesKey = aesKey;
        this.authTag = authTag;
        this.payload = payload;
    }

    public String getIv() {
        return this.iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public String getKey() {
        return this.aesKey;
    }

    public void setKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public String getAuthTag() {
        return this.authTag;
    }

    public void setAuthTag(String authTag) {
        this.authTag = authTag;
    }

    public String getCipherText() {
        return this.payload;
    }

    public void setCipherText(String cipherText) {
        this.payload = cipherText;
    }

    public static int getGcmTagLength() {
        return 16;
    }

    public String decryptPayload() throws Exception {
        byte[] bKey = Hex.decodeHex((char[])this.aesKey.toCharArray());
        byte[] bIV = Hex.decodeHex((char[])this.iv.toCharArray());
        byte[] encryptedBytes = Hex.decodeHex((char[])(this.payload + this.authTag).toCharArray());
        SecretKeySpec sKey = new SecretKeySpec(bKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
        GCMParameterSpec spec = new GCMParameterSpec(128, bIV);
        cipher.init(2, (Key)sKey, spec);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }
}

