/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.forwardpayments.implementations;

import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAVirtualImplementation;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.forwardpayments.IForwardPaymentController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@SpringFunctionality(app=TreasuryController.class, title="label.title.tpaReturnForwardPayment", accessGroup="logged")
@RequestMapping(value={"/treasury/document/forwardpayments/tpavirtual"})
public class TPAVirtualController
extends TreasuryBaseController
implements IForwardPaymentController {
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/tpavirtual";
    private static final String JSP_PATH = "/treasury/document/forwardpayments/forwardpayment/implementations/tpavirtual";
    private static final String RETURN_FORWARD_PAYMENT_URI = "/returnforwardpayment";
    public static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/tpavirtual/returnforwardpayment";
    private static final String CURRENT_FORWARD_PAYMENT_STATE_URI = "/currentforwardpaymentstate";
    public static final String CURRENT_FORWARD_PAYMENT_STATE_URL = "/treasury/document/forwardpayments/tpavirtual/currentforwardpaymentstate";

    @Override
    public String processforwardpayment(ForwardPayment forwardPayment, Model model, HttpServletResponse response, HttpSession session) {
        model.addAttribute("forwardPaymentConfiguration", (Object)forwardPayment.getForwardPaymentConfiguration());
        model.addAttribute("forwardPayment", (Object)forwardPayment);
        return this.jspPage("hostedPay");
    }

    @RequestMapping(value={"/returnforwardpayment/{forwardPaymentId}"}, method={RequestMethod.POST}, produces={"text/html"})
    public String returnforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, @RequestParam Map<String, String> responseData, Model model, HttpServletResponse response) {
        TPAVirtualImplementation implementation = (TPAVirtualImplementation)forwardPayment.getForwardPaymentConfiguration().implementation();
        model.addAttribute("forwardPaymentConfiguration", (Object)forwardPayment.getForwardPaymentConfiguration());
        try {
            boolean success = implementation.processPayment(forwardPayment, responseData);
            if (success) {
                return String.format("redirect:%s", forwardPayment.getForwardPaymentSuccessUrl());
            }
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/currentforwardpaymentstate/{forwardPaymentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public String currentforwardpaymentstate(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment) {
        return forwardPayment.getCurrentState().toString();
    }

    private String jspPage(String page) {
        return "/treasury/document/forwardpayments/forwardpayment/implementations/tpavirtual/" + page;
    }
}

