/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managecurrency;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.managecurrency.CurrencyController$callable$createCurrency;
import org.fenixedu.treasury.ui.administration.base.managecurrency.CurrencyController$callable$deleteCurrency;
import org.fenixedu.treasury.ui.administration.base.managecurrency.CurrencyController$callable$updateCurrency;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageCurrency", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/managecurrency/currency"})
public class CurrencyController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managecurrency/currency";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/managecurrency/currency/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managecurrency/currency/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managecurrency/currency/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managecurrency/currency/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managecurrency/currency/delete/";
    private static final String SEARCH_VIEW_URI = "/search/view/";
    public static final String SEARCH_VIEW_URL = "/treasury/administration/base/managecurrency/currency/search/view/";
    public static final Advice advice$deleteCurrency = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createCurrency = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateCurrency = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managecurrency/currency/";
    }

    private Currency getCurrency(Model m) {
        return (Currency)((Object)m.asMap().get("currency"));
    }

    private void setCurrency(Currency currency, Model m) {
        m.addAttribute("currency", (Object)currency);
    }

    public void deleteCurrency(Currency currency) {
        Object object = advice$deleteCurrency.perform((Callable)new CurrencyController$callable$deleteCurrency(this, currency));
    }

    static /* synthetic */ void advised$deleteCurrency(CurrencyController this_, Currency currency) {
        currency.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="isocode", required=false) String isoCode, @RequestParam(value="symbol", required=false) String symbol, Model model) {
        List<Currency> searchcurrencyResultsDataSet = this.filterSearchCurrency(code, name, isoCode, symbol);
        model.addAttribute("searchcurrencyResultsDataSet", searchcurrencyResultsDataSet);
        return "treasury/administration/base/managecurrency/currency/search";
    }

    private List<Currency> getSearchUniverseSearchCurrencyDataSet() {
        return Currency.findAll().collect(Collectors.toList());
    }

    private List<Currency> filterSearchCurrency(String code, LocalizedString name, String isoCode, String symbol) {
        return this.getSearchUniverseSearchCurrencyDataSet().stream().filter(currency -> code == null || code.length() == 0 || currency.getCode() != null && currency.getCode().length() > 0 && currency.getCode().toLowerCase().contains(code.toLowerCase())).filter(currency -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> currency.getName().getContent(locale) != null && currency.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).filter(currency -> isoCode == null || isoCode.length() == 0 || currency.getIsoCode() != null && currency.getIsoCode().length() > 0 && currency.getIsoCode().toLowerCase().contains(isoCode.toLowerCase())).filter(currency -> symbol == null || symbol.length() == 0 || currency.getSymbol() != null && currency.getSymbol().length() > 0 && currency.getSymbol().toLowerCase().contains(symbol.toLowerCase())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") Currency currency, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + currency.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") Currency currency, Model model) {
        this.setCurrency(currency, model);
        return "treasury/administration/base/managecurrency/currency/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") Currency currency, Model model, RedirectAttributes redirectAttributes) {
        this.setCurrency(currency, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteCurrency(currency);
            this.addInfoMessage(TreasuryConstants.treasuryBundle("label.success.delete", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getCurrency(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/managecurrency/currency/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="isocode", required=false) String isoCode, @RequestParam(value="symbol", required=false) String symbol, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            Currency currency = this.createCurrency(code, name, isoCode, symbol);
            model.addAttribute("currency", (Object)currency);
            return this.redirect(READ_URL + this.getCurrency(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public Currency createCurrency(String string, LocalizedString localizedString, String string2, String string3) {
        return (Currency)((Object)advice$createCurrency.perform((Callable)new CurrencyController$callable$createCurrency(this, string, localizedString, string2, string3)));
    }

    static /* synthetic */ Currency advised$createCurrency(CurrencyController this_, String code, LocalizedString name, String isoCode, String symbol) {
        Currency currency = Currency.create(code, name, isoCode, symbol);
        return currency;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") Currency currency, Model model) {
        this.setCurrency(currency, model);
        return "treasury/administration/base/managecurrency/currency/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") Currency currency, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="isocode", required=false) String isoCode, @RequestParam(value="symbol", required=false) String symbol, Model model, RedirectAttributes redirectAttributes) {
        this.setCurrency(currency, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateCurrency(code, name, isoCode, symbol, model);
            return this.redirect(READ_URL + this.getCurrency(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(currency, model);
    }

    public void updateCurrency(String string, LocalizedString localizedString, String string2, String string3, Model model) {
        Object object = advice$updateCurrency.perform((Callable)new CurrencyController$callable$updateCurrency(this, string, localizedString, string2, string3, model));
    }

    static /* synthetic */ void advised$updateCurrency(CurrencyController this_, String code, LocalizedString name, String isoCode, String symbol, Model m) {
        this_.getCurrency(m).edit(code, name, isoCode, symbol);
    }
}

