/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.ui.accounting.managecustomer.PaymentReferenceCodeController$callable$createPaymentReferenceCode;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Component(value="org.fenixedu.treasury.ui.accounting.managecustomer")
@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/paymentreferencecode"})
public class PaymentReferenceCodeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/accounting/managecustomer/paymentreferencecode";
    private static final String JSP_PATH = "treasury/accounting/managecustomer/paymentreferencecode";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URI = "/createpaymentcodeforseveraldebitentries";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URL = "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentries";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URI = "/createpaymentcodeforseveraldebitentriespostback";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URL = "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentriespostback";
    public static final Advice advice$createPaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/accounting/managecustomer/paymentreferencecode/";
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.GET})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
        PaymentReferenceCodeBean bean = new PaymentReferenceCodeBean(debtAccount);
        return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
    }

    private String _createPaymentCodeForSeveralDebitEntries(DebtAccount debtAccount, PaymentReferenceCodeBean bean, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createpaymentcodeforseveraldebitentries");
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentriespostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createPaymentCodeForSeveralDebitEntriesPostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model) {
        bean.updateAmountOnSelectedDebitEntries();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.POST})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
        try {
            if (bean.getSelectedDebitEntries() == null || bean.getSelectedDebitEntries().isEmpty()) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle("error.MultipleEntriesPaymentCode.select.at.least.one.debit.entry", new String[0]), model);
                return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
            }
            if (bean.getPaymentCodePool() == null) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle("error.MultipleEntriesPaymentCode.payment.code.pool.required", new String[0]), model);
                return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
            }
            this.assertUserIsFrontOfficeMember(bean.getSelectedDebitEntries().iterator().next().getDebtAccount().getFinantialInstitution(), model);
            PaymentReferenceCode paymentReferenceCode = this.createPaymentReferenceCode(bean);
            this.addInfoMessage(TreasuryConstants.treasuryBundle("label.document.managepayments.success.create.reference.code.selected.debit.entries", new String[0]), model);
            return this.redirect(String.format("/treasury/accounting/managecustomer/debtaccount/read//%s", debtAccount.getExternalId()), model, redirectAttributes);
        }
        catch (TreasuryDomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
        }
    }

    private PaymentReferenceCode createPaymentReferenceCode(PaymentReferenceCodeBean paymentReferenceCodeBean) {
        return (PaymentReferenceCode)((Object)advice$createPaymentReferenceCode.perform((Callable)new PaymentReferenceCodeController$callable$createPaymentReferenceCode(this, paymentReferenceCodeBean)));
    }

    static /* synthetic */ PaymentReferenceCode advised$createPaymentReferenceCode(PaymentReferenceCodeController this_, PaymentReferenceCodeBean bean) {
        PaymentReferenceCode paymentReferenceCode = bean.getPaymentCodePool().getReferenceCodeGenerator().generateNewCodeFor(bean.getPaymentAmount(), bean.getBeginDate(), bean.getEndDate(), bean.getPaymentCodePool().getIsFixedAmount());
        paymentReferenceCode.createPaymentTargetTo(Sets.newHashSet(bean.getSelectedDebitEntries()), bean.getPaymentAmount());
        return paymentReferenceCode;
    }

    private String jspPage(String page) {
        return "treasury/accounting/managecustomer/paymentreferencecode/" + page;
    }
}

