/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports.helpers;

import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import java.util.Locale;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.YearMonthDay;

public class DateHelper
implements IDocumentHelper {
    Locale pt = new Locale("pt");

    public String numericDate(LocalDate localDate) {
        return localDate.toString("dd/MM/yyyy");
    }

    public String numericDate(YearMonthDay yearMonthDay) {
        return this.numericDate(yearMonthDay.toLocalDate());
    }

    public String numericDateTime(DateTime dateTime) {
        return dateTime.toString("dd/MM/yyyy HH:mm");
    }

    public LocalizedString extendedDate(LocalDate localDate) {
        LocalizedString i18NString = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            String month = localDate.toString("MMMM", locale);
            if (locale.getLanguage().equals("pt")) {
                month = month.toLowerCase();
            }
            String message = BundleUtil.getString((String)"resources.FenixeduQubdocsReportsResources", (Locale)locale, (String)"message.DateHelper.extendedDate", (String[])new String[]{localDate.toString("dd", locale), month, localDate.toString("yyyy", locale)});
            i18NString = i18NString.with(locale, message);
        }
        return i18NString;
    }

    public LocalizedString extendedDate(YearMonthDay yearMonthDay) {
        return this.extendedDate(yearMonthDay.toLocalDate());
    }

    public String monthYear(Partial partial) {
        return partial.toString("MM/yyyy");
    }

    public String monthYear(LocalDate localDate) {
        return localDate.toString("MM/yyyy");
    }

    public String date(DateTime dateTime) {
        return dateTime.toString("dd/MM/yyyy");
    }

    public String date(LocalDate localDate) {
        return localDate.toString("dd/MM/yyyy");
    }

    public String date(YearMonthDay yearMonthDay) {
        return yearMonthDay.toString("dd/MM/yyyy");
    }
}

