/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForDebitEntry;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForDebitEntry$1;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForTariff;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$delete;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$edit;
import org.fenixedu.treasury.domain.tariff.InterestRate_Base;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class InterestRate
extends InterestRate_Base {
    private static final int MAX_YEARS = 5;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForTariff = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForDebitEntry$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected InterestRate() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected InterestRate(Tariff tariff, DebitEntry debitEntry, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this();
        this.setTariff(tariff);
        this.setDebitEntry(debitEntry);
        this.setInterestType(interestType);
        this.setNumberOfDaysAfterDueDate(1);
        this.setApplyInFirstWorkday(applyInFirstWorkday);
        this.setMaximumDaysToApplyPenalty(maximumDaysToApplyPenalty);
        this.setMaximumMonthsToApplyPenalty(maximumMonthsToApplyPenalty);
        this.setInterestFixedAmount(interestFixedAmount);
        this.setRate(rate);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTariff() == null && this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.InterestRate.product.or.debit.entry.required", new String[0]);
        }
        if (this.getTariff() != null && this.getDebitEntry() != null) {
            throw new TreasuryDomainException("error.InterestRate.product.or.debit.entry.only.one", new String[0]);
        }
        if (this.getInterestType() == null) {
            throw new TreasuryDomainException("error.InterestRate.interestType.required", new String[0]);
        }
        if ((this.getInterestType().isDaily() || this.getInterestType().isMonthly()) && this.getRate() == null) {
            throw new TreasuryDomainException("error.InterestRate.rate.required", new String[0]);
        }
        if (this.getInterestType().isFixedAmount() && this.getInterestFixedAmount() == null) {
            throw new TreasuryDomainException("error.InterestRate.interestFixedAmount.required", new String[0]);
        }
    }

    public boolean isMaximumDaysToApplyPenaltyApplied() {
        return this.getMaximumDaysToApplyPenalty() > 0;
    }

    public boolean isMaximumMonthsToApplyPenaltyApplied() {
        return this.getMaximumMonthsToApplyPenalty() > 0;
    }

    public boolean isApplyInFirstWorkday() {
        return this.getApplyInFirstWorkday();
    }

    public void edit(InterestType interestType, int n, boolean bl, int n2, int n3, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object = advice$edit.perform((Callable)new InterestRate$callable$edit(this, interestType, n, bl, n2, n3, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ void advised$edit(InterestRate this_, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this_.setInterestType(interestType);
        this_.setNumberOfDaysAfterDueDate(1);
        this_.setApplyInFirstWorkday(applyInFirstWorkday);
        this_.setMaximumDaysToApplyPenalty(maximumDaysToApplyPenalty);
        this_.setMaximumMonthsToApplyPenalty(maximumMonthsToApplyPenalty);
        this_.setInterestFixedAmount(interestFixedAmount);
        this_.setRate(rate);
        this_.checkRules();
    }

    public InterestRateBean calculateInterest(Map<LocalDate, BigDecimal> amountInDebtMap, Map<LocalDate, BigDecimal> createdInterestEntries, LocalDate dueDate, LocalDate paymentDate) {
        TreeMap<LocalDate, BigDecimal> sortedMap = new TreeMap<LocalDate, BigDecimal>();
        sortedMap.putAll(amountInDebtMap);
        if (this.getInterestType().isGlobalRate() && !GlobalInterestRate.findUniqueByYear(dueDate.getYear()).get().isApplyPaymentMonth()) {
            LocalDate lastDayForInterestCalculation = paymentDate.withField(DateTimeFieldType.dayOfMonth(), 1).minusDays(1);
            for (LocalDate localDate : Sets.newTreeSet(sortedMap.keySet())) {
                if (!localDate.isAfter((ReadablePartial)lastDayForInterestCalculation)) continue;
                sortedMap.remove(localDate);
            }
            sortedMap.put(lastDayForInterestCalculation, BigDecimal.ZERO);
        } else {
            sortedMap.put(paymentDate, BigDecimal.ZERO);
        }
        sortedMap = this.splitDatesWithYearsSpan(sortedMap);
        if (this.getInterestType().isFixedAmount()) {
            return this.calculedForFixedAmount();
        }
        if (this.getInterestType().isDaily() || this.getInterestType().isGlobalRate()) {
            return this.calculateDaily(createdInterestEntries, dueDate, paymentDate, sortedMap);
        }
        if (this.getInterestType().isMonthly()) {
            return this.calculateMonthly(createdInterestEntries, dueDate, paymentDate, sortedMap);
        }
        throw new RuntimeException("unknown interest type formula");
    }

    private TreeMap<LocalDate, BigDecimal> splitDatesWithYearsSpan(TreeMap<LocalDate, BigDecimal> sortedMap) {
        TreeMap<LocalDate, BigDecimal> result = new TreeMap<LocalDate, BigDecimal>();
        LocalDate startDate = null;
        for (Map.Entry<LocalDate, BigDecimal> entry : sortedMap.entrySet()) {
            if (startDate == null) {
                result.put(entry.getKey(), entry.getValue());
                startDate = entry.getKey();
                continue;
            }
            if (startDate.getYear() == entry.getKey().getYear()) {
                result.put(entry.getKey(), entry.getValue());
                startDate = entry.getKey();
                continue;
            }
            if (startDate.getYear() == entry.getKey().getYear() - 1) {
                result.put(entry.getKey(), entry.getValue());
                startDate = entry.getKey();
                continue;
            }
            LocalDate a = startDate.plusYears(1);
            LocalDate b = entry.getKey();
            while (a.getYear() < b.getYear()) {
                result.put(TreasuryConstants.firstDayInYear(a.getYear()), sortedMap.get(startDate));
                a = a.plusYears(1);
            }
            result.put(entry.getKey(), entry.getValue());
            startDate = entry.getKey();
        }
        return result;
    }

    private InterestRateBean calculateMonthly(Map<LocalDate, BigDecimal> createdInterestEntries, LocalDate dueDate, LocalDate paymentDate, TreeMap<LocalDate, BigDecimal> sortedMap) {
        LocalDate dueDateToUse = dueDate;
        if (dueDate.isBefore((ReadablePartial)paymentDate.minusYears(5))) {
            dueDateToUse = paymentDate.minusYears(5);
        }
        InterestRateBean result = new InterestRateBean(this.getInterestType());
        BigDecimal totalInterestAmount = BigDecimal.ZERO;
        int totalOfMonths = 0;
        LocalDate startDate = dueDateToUse.plusMonths(1).withDayOfMonth(1);
        BigDecimal amountInDebt = null;
        for (Map.Entry<LocalDate, BigDecimal> entry : sortedMap.entrySet()) {
            if (entry.getKey().isAfter((ReadablePartial)paymentDate)) break;
            if (entry.getKey().isBefore((ReadablePartial)startDate)) {
                amountInDebt = entry.getValue();
                continue;
            }
            LocalDate endDate = entry.getKey();
            int numberOfMonths = Months.monthsBetween((ReadablePartial)startDate, (ReadablePartial)endDate).getMonths();
            BigDecimal amountByRate = TreasuryConstants.divide(this.getRate(), TreasuryConstants.HUNDRED_PERCENT).multiply(amountInDebt);
            BigDecimal partialInterestAmount = amountByRate.multiply(new BigDecimal(numberOfMonths));
            if (TreasuryConstants.isPositive(partialInterestAmount)) {
                result.addDetail(partialInterestAmount, startDate, endDate, amountByRate, amountInDebt);
            }
            totalInterestAmount = totalInterestAmount.add(partialInterestAmount);
            totalOfMonths += numberOfMonths;
            amountInDebt = entry.getValue();
            startDate = endDate;
        }
        if (createdInterestEntries != null) {
            TreeMap<LocalDate, BigDecimal> interestSortedMap = new TreeMap<LocalDate, BigDecimal>();
            interestSortedMap.putAll(createdInterestEntries);
            for (Map.Entry<LocalDate, BigDecimal> entry : createdInterestEntries.entrySet()) {
                result.addCreatedInterestEntry(entry.getKey(), entry.getValue());
                totalInterestAmount = totalInterestAmount.subtract(entry.getValue());
            }
        }
        result.setInterestAmount(this.getRelatedCurrency().getValueWithScale(totalInterestAmount));
        result.setNumberOfMonths(totalOfMonths);
        return result;
    }

    private InterestRateBean calculateDaily(Map<LocalDate, BigDecimal> createdInterestEntries, LocalDate dueDate, LocalDate paymentDate, TreeMap<LocalDate, BigDecimal> sortedMap) {
        LocalDate dueDateToUse = dueDate;
        if (dueDate.isBefore((ReadablePartial)paymentDate.minusYears(5))) {
            dueDateToUse = paymentDate.minusYears(5);
        }
        InterestRateBean result = new InterestRateBean(this.getInterestType());
        BigDecimal totalInterestAmount = BigDecimal.ZERO;
        int totalOfDays = 0;
        LocalDate startDate = this.applyOnFirstWorkdayIfNecessary(dueDateToUse.plusDays(this.numberOfDaysAfterDueDate(dueDateToUse.getYear())));
        BigDecimal amountInDebt = BigDecimal.ZERO;
        for (Map.Entry<LocalDate, BigDecimal> entry : sortedMap.entrySet()) {
            BigDecimal partialInterestAmount;
            if (entry.getKey().isAfter((ReadablePartial)paymentDate)) break;
            if (entry.getKey().isBefore((ReadablePartial)startDate)) {
                amountInDebt = entry.getValue();
                continue;
            }
            LocalDate endDate = entry.getKey();
            int numberOfDays = 0;
            if (startDate.getYear() != endDate.getYear()) {
                boolean reachedMaxDays = false;
                int firstYearDays = Days.daysBetween((ReadablePartial)startDate, (ReadablePartial)TreasuryConstants.lastDayInYear(startDate.getYear())).getDays() + 1;
                int secondYearDays = Days.daysBetween((ReadablePartial)TreasuryConstants.firstDayInYear(endDate.getYear()), (ReadablePartial)endDate).getDays() + 1;
                if (this.isMaximumDaysToApplyPenaltyApplied() && totalOfDays + firstYearDays >= this.getMaximumDaysToApplyPenalty()) {
                    firstYearDays = this.getMaximumDaysToApplyPenalty() - totalOfDays;
                    reachedMaxDays = true;
                }
                BigDecimal amountPerDay = TreasuryConstants.divide(amountInDebt, new BigDecimal(TreasuryConstants.numberOfDaysInYear(startDate.getYear())));
                BigDecimal rate = this.interestRate(startDate.getYear());
                partialInterestAmount = TreasuryConstants.divide(rate, TreasuryConstants.HUNDRED_PERCENT).multiply(amountPerDay).multiply(new BigDecimal(firstYearDays));
                numberOfDays += firstYearDays;
                if (TreasuryConstants.isPositive(partialInterestAmount)) {
                    result.addDetail(partialInterestAmount, startDate, TreasuryConstants.lastDayInYear(startDate.getYear()), amountPerDay, amountInDebt);
                }
                if (!reachedMaxDays) {
                    if (this.isMaximumDaysToApplyPenaltyApplied() && totalOfDays + firstYearDays + secondYearDays >= this.getMaximumDaysToApplyPenalty()) {
                        secondYearDays = this.getMaximumDaysToApplyPenalty() - totalOfDays - firstYearDays;
                    }
                    amountPerDay = TreasuryConstants.divide(amountInDebt, new BigDecimal(TreasuryConstants.numberOfDaysInYear(endDate.getYear())));
                    rate = this.interestRate(endDate.getYear());
                    BigDecimal secondInterestAmount = TreasuryConstants.divide(rate, TreasuryConstants.HUNDRED_PERCENT).multiply(amountPerDay).multiply(new BigDecimal(secondYearDays));
                    if (TreasuryConstants.isPositive(partialInterestAmount)) {
                        result.addDetail(secondInterestAmount, TreasuryConstants.firstDayInYear(endDate.getYear()), endDate, amountPerDay, amountInDebt);
                    }
                    partialInterestAmount = partialInterestAmount.add(secondInterestAmount);
                    numberOfDays += secondYearDays;
                }
            } else {
                numberOfDays = Days.daysBetween((ReadablePartial)startDate, (ReadablePartial)endDate).getDays() + 1;
                if (this.isMaximumDaysToApplyPenaltyApplied() && totalOfDays + numberOfDays >= this.getMaximumDaysToApplyPenalty()) {
                    numberOfDays = this.getMaximumDaysToApplyPenalty() - totalOfDays;
                }
                BigDecimal amountPerDay = TreasuryConstants.divide(amountInDebt, new BigDecimal(TreasuryConstants.numberOfDaysInYear(startDate.getYear())));
                BigDecimal rate = this.interestRate(startDate.getYear());
                partialInterestAmount = TreasuryConstants.divide(rate, TreasuryConstants.HUNDRED_PERCENT).multiply(amountPerDay).multiply(new BigDecimal(numberOfDays));
                if (TreasuryConstants.isPositive(partialInterestAmount)) {
                    result.addDetail(partialInterestAmount, startDate, endDate, amountPerDay, amountInDebt);
                }
            }
            totalInterestAmount = totalInterestAmount.add(partialInterestAmount);
            amountInDebt = entry.getValue();
            startDate = endDate.plusDays(1);
            if (!this.isMaximumDaysToApplyPenaltyApplied() || (totalOfDays += numberOfDays) < this.getMaximumDaysToApplyPenalty()) continue;
            break;
        }
        if (createdInterestEntries != null) {
            TreeMap<LocalDate, BigDecimal> interestSortedMap = new TreeMap<LocalDate, BigDecimal>();
            interestSortedMap.putAll(createdInterestEntries);
            for (Map.Entry<LocalDate, BigDecimal> entry : createdInterestEntries.entrySet()) {
                result.addCreatedInterestEntry(entry.getKey(), entry.getValue());
                totalInterestAmount = totalInterestAmount.subtract(entry.getValue());
            }
        }
        result.setInterestAmount(this.getRelatedCurrency().getValueWithScale(totalInterestAmount));
        result.setNumberOfDays(totalOfDays);
        return result;
    }

    private int numberOfDaysAfterDueDate(int year) {
        if (this.getInterestType().isGlobalRate()) {
            return 1;
        }
        return this.getNumberOfDaysAfterDueDate();
    }

    private Currency getRelatedCurrency() {
        if (this.getTariff() != null) {
            return this.getTariff().getFinantialEntity().getFinantialInstitution().getCurrency();
        }
        if (this.getDebitEntry() != null) {
            return this.getDebitEntry().getCurrency();
        }
        return null;
    }

    private BigDecimal interestRate(int year) {
        if (this.getInterestType().isGlobalRate()) {
            if (!GlobalInterestRate.findUniqueByYear(year).isPresent()) {
                throw new TreasuryDomainException("error.InterestRate.global.interest.rate.not.found", String.valueOf(year));
            }
            return GlobalInterestRate.findUniqueByYear(year).get().getRate();
        }
        return this.getRate();
    }

    private InterestRateBean calculedForFixedAmount() {
        InterestRateBean result = new InterestRateBean(this.getInterestType());
        result.setInterestAmount(this.getRelatedCurrency().getValueWithScale(this.getInterestFixedAmount()));
        return result;
    }

    private LocalDate applyOnFirstWorkdayIfNecessary(LocalDate date) {
        boolean applyInFirstWorkday = this.isApplyInFirstWorkday();
        if (this.getInterestType().isGlobalRate()) {
            if (!GlobalInterestRate.findUniqueByYear(date.getYear()).isPresent()) {
                throw new TreasuryDomainException("error.InterestRate.global.interest.rate.not.found", String.valueOf(date.getYear()));
            }
            applyInFirstWorkday = GlobalInterestRate.findUniqueByYear(date.getYear()).get().getApplyInFirstWorkday();
        }
        if (applyInFirstWorkday && this.isSaturday(date)) {
            return date.plusDays(2);
        }
        if (applyInFirstWorkday && this.isSunday(date)) {
            return date.plusDays(1);
        }
        return date;
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new InterestRate$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(InterestRate this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.InterestRate.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTariff(null);
        this_.setDebitEntry(null);
        this_.deleteDomainObject();
    }

    private boolean isSaturday(LocalDate date) {
        return date.getDayOfWeek() == 6;
    }

    private boolean isSunday(LocalDate date) {
        return date.getDayOfWeek() == 7;
    }

    public static Stream<InterestRate> findAll() {
        return FenixFramework.getDomainRoot().getInterestRatesSet().stream();
    }

    public static InterestRate createForTariff(Tariff tariff, InterestType interestType, int n, boolean bl, int n2, int n3, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (InterestRate)((Object)advice$createForTariff.perform((Callable)new InterestRate$callable$createForTariff(tariff, interestType, n, bl, n2, n3, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ InterestRate advised$createForTariff(Tariff tariff, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        return new InterestRate(tariff, null, interestType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, maximumMonthsToApplyPenalty, interestFixedAmount, rate);
    }

    public String getUiFullDescription() {
        switch (this.getInterestType()) {
            case DAILY: {
                return this.getInterestType().getDescriptionI18N().getContent() + "-" + this.getRate() + "% (Max. Dias=" + this.getMaximumDaysToApplyPenalty() + ", Aplica 1\u00ba Dia \u00datil=" + this.getApplyInFirstWorkday() + ", Dias ap\u00f3s Vencimento=" + this.getNumberOfDaysAfterDueDate() + ")";
            }
            case FIXED_AMOUNT: {
                return this.getInterestType().getDescriptionI18N().getContent() + "-" + this.getRelatedCurrency().getValueFor(this.getInterestFixedAmount());
            }
            case GLOBAL_RATE: {
                return this.getInterestType().getDescriptionI18N().getContent();
            }
            case MONTHLY: {
                return this.getInterestType().getDescriptionI18N().getContent() + "-" + this.getRate() + "% (Max. Meses=" + this.getMaximumMonthsToApplyPenalty() + ")";
            }
        }
        return this.getInterestType().getDescriptionI18N().getContent();
    }

    public static InterestRate createForDebitEntry(DebitEntry debitEntry, InterestRate interestRate) {
        return (InterestRate)((Object)advice$createForDebitEntry.perform((Callable)new InterestRate$callable$createForDebitEntry(debitEntry, interestRate)));
    }

    static /* synthetic */ InterestRate advised$createForDebitEntry(DebitEntry debitEntry, InterestRate interestRate) {
        if (interestRate != null) {
            return new InterestRate(null, debitEntry, interestRate.getInterestType(), interestRate.getNumberOfDaysAfterDueDate(), interestRate.getApplyInFirstWorkday(), interestRate.getMaximumDaysToApplyPenalty(), interestRate.getMaximumMonthsToApplyPenalty(), interestRate.getInterestFixedAmount(), interestRate.getRate());
        }
        return null;
    }

    public static InterestRate createForDebitEntry(DebitEntry debitEntry, InterestType interestType, int n, boolean bl, int n2, int n3, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (InterestRate)((Object)advice$createForDebitEntry$1.perform((Callable)new InterestRate$callable$createForDebitEntry$1(debitEntry, interestType, n, bl, n2, n3, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ InterestRate advised$createForDebitEntry(DebitEntry debitEntry, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        return new InterestRate(null, debitEntry, interestType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, maximumMonthsToApplyPenalty, interestFixedAmount, rate);
    }
}

