/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFileDomainObject$callable$createFromSibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFileDomainObject$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFileDomainObject$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFileDomainObject$callable$updateLogMessages;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFileDomainObject_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsSpreadsheetRowReportBean;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationFileDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationLineDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsReportFileDomainObject
extends SibsReportFileDomainObject_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";
    public static final String FILE_EXTENSION = ".idm";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createFromSibsReportFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateLogMessages = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected SibsReportFileDomainObject() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, String displayName, String fileName, byte[] content) {
        TreasuryPlataformDependentServicesFactory.implementation().createFile(this, fileName, CONTENT_TYPE, content);
        this.setWhenProcessedBySibs(whenProcessedBySibs);
        this.setTransactionsTotalAmount(transactionsTotalAmount);
        this.setTotalCost(totalCost);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit(DateTime dateTime, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object = advice$edit.perform((Callable)new SibsReportFileDomainObject$callable$edit(this, dateTime, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ void advised$edit(SibsReportFileDomainObject this_, DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost) {
        this_.setWhenProcessedBySibs(whenProcessedBySibs);
        this_.setTransactionsTotalAmount(transactionsTotalAmount);
        this_.setTotalCost(totalCost);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getReferenceCodesSet().isEmpty() && this.getSibsTransactionsSet().isEmpty();
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsReportFileDomainObject$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsReportFileDomainObject this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SibsReportFile.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTreasuryFile(null);
        super.deleteDomainObject();
    }

    public static Stream<SibsReportFileDomainObject> findAll() {
        return FenixFramework.getDomainRoot().getSibsReportFileDomainObjectsSet().stream();
    }

    public static Stream<SibsReportFileDomainObject> findByTransactionsTotalAmount(BigDecimal transactionsTotalAmount) {
        return SibsReportFileDomainObject.findAll().filter(i -> transactionsTotalAmount.equals(i.getTransactionsTotalAmount()));
    }

    public static Stream<SibsReportFileDomainObject> findByTotalCost(BigDecimal totalCost) {
        return SibsReportFileDomainObject.findAll().filter(i -> totalCost.equals(i.getTotalCost()));
    }

    public static Optional<SibsReportFileDomainObject> findUniqueBySibsReportFile(SibsReportFile file) {
        return SibsReportFileDomainObject.findAll().filter(o -> o.getTreasuryFile() == file).findFirst();
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username);
    }

    public static SibsReportFileDomainObject createFromSibsReportFile(SibsReportFile sibsReportFile) {
        return (SibsReportFileDomainObject)advice$createFromSibsReportFile.perform((Callable)new SibsReportFileDomainObject$callable$createFromSibsReportFile(sibsReportFile));
    }

    static /* synthetic */ SibsReportFileDomainObject advised$createFromSibsReportFile(SibsReportFile file) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        SibsReportFileDomainObject result = new SibsReportFileDomainObject();
        result.setWhenProcessedBySibs(file.getWhenProcessedBySibs());
        result.setTransactionsTotalAmount(file.getTransactionsTotalAmount());
        result.setTotalCost(file.getTotalCost());
        result.setErrorLog(file.getErrorLog());
        result.setInfoLog(file.getInfoLog());
        result.setCreationDate(file.getCreationDate());
        result.setCreator(services.versioningCreatorUsername(file));
        result.setTreasuryFile((TreasuryFile)((Object)file));
        result.setFileId(file.getExternalId());
        result.getReferenceCodesSet().addAll(file.getReferenceCodesSet());
        result.getSibsTransactionsSet().addAll(file.getSibsTransactionsSet());
        result.checkRules();
        return result;
    }

    protected static byte[] buildContentFor(SIBSImportationFileDTO reportFileDTO) {
        final Stream<SibsSpreadsheetRowReportBean> lines = reportFileDTO.getLines().stream().map(l -> new SibsSpreadsheetRowReportBean((SIBSImportationLineDTO)l));
        return Spreadsheet.buildSpreadsheetContent(new Spreadsheet(){

            @Override
            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create(TreasuryConstants.treasuryBundle("label.SibsReportFile.spreadsheet.name", new String[0]), SibsSpreadsheetRowReportBean.SPREADSHEET_HEADERS, lines)};
            }
        }, null);
    }

    protected static String filenameFor(SIBSImportationFileDTO reportFileDTO) {
        String date = new DateTime().toString("yyyyMMddHHmm");
        return "Relatorio-SIBS-" + date + ".xlsx";
    }

    protected static String displayNameFor(SIBSImportationFileDTO reportFileDTO) {
        String date = new DateTime().toString("yyyyMMddHHmm");
        return "Relatorio-SIBS-" + date;
    }

    public Integer getNumberOfTransactions() {
        return this.getSibsTransactionsSet().size();
    }

    public String getTransactionDescription(Integer index) {
        if (this.getSibsTransactionsSet().size() > index) {
            if (index > 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().stream().skip(index - 1).findFirst().get())).toString();
            }
            if (index == 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().iterator().next())).toString();
            }
        }
        return "";
    }

    public BigDecimal getTransactionAmount(Integer index) {
        if (this.getSibsTransactionsSet().size() > index) {
            if (index > 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().stream().skip(index - 1).findFirst().get())).getAmountPayed();
            }
            if (index == 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().iterator().next())).getAmountPayed();
            }
        }
        return BigDecimal.ZERO;
    }

    public void updateLogMessages(SIBSPaymentsImporter.ProcessResult processResult) {
        Object object = advice$updateLogMessages.perform((Callable)new SibsReportFileDomainObject$callable$updateLogMessages(this, processResult));
    }

    static /* synthetic */ void advised$updateLogMessages(SibsReportFileDomainObject this_, SIBSPaymentsImporter.ProcessResult result) {
        StringBuilder build = new StringBuilder();
        for (String s : result.getErrorMessages()) {
            build.append(s + "\n");
        }
        this_.setErrorLog(build.toString());
        build = new StringBuilder();
        for (String s : result.getActionMessages()) {
            build.append(s + "\n");
        }
        this_.setInfoLog(build.toString());
    }
}

