/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFileDomainObject$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFileDomainObject_Base;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsInputFileDomainObject
extends SibsInputFileDomainObject_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected SibsInputFileDomainObject() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(FinantialInstitution finantialInstitution, DateTime whenProcessedBySIBS, String displayName, String filename, byte[] content, String uploader) {
        TreasuryPlataformDependentServicesFactory.implementation().createFile(this, filename, CONTENT_TYPE, content);
        this.setWhenProcessedBySibs(whenProcessedBySIBS);
        this.setUploaderUsername(uploader);
        this.setFinantialInstitution(finantialInstitution);
        this.checkRules();
    }

    private void checkRules() {
    }

    public boolean isDeletable() {
        return true;
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsInputFileDomainObject$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsInputFileDomainObject this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SibsInputFile.cannot.delete", new String[0]);
        }
        this_.setFinantialInstitution(null);
        this_.setDomainRoot(null);
        this_.setTreasuryFile(null);
        super.deleteDomainObject();
    }

    public static SibsInputFileDomainObject createFromSibsInputFile(SibsInputFile file) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        SibsInputFileDomainObject result = new SibsInputFileDomainObject();
        result.setWhenProcessedBySibs(file.getWhenProcessedBySibs());
        result.setUploaderUsername(file.getUploaderUsername());
        result.setFinantialInstitution(file.getFinantialInstitution());
        result.setTreasuryFile((TreasuryFile)((Object)file));
        result.setCreationDate(file.getCreationDate());
        result.setCreator(services.versioningCreatorUsername(file));
        result.setFileId(file.getExternalId());
        return result;
    }

    public static Stream<SibsInputFileDomainObject> findAll() {
        return FenixFramework.getDomainRoot().getSibsInputFileDomainObjectsSet().stream();
    }

    public static Optional<SibsInputFileDomainObject> findUniqueBySibsInputFile(SibsInputFile file) {
        return SibsInputFileDomainObject.findAll().filter(o -> o.getTreasuryFile() == file).findFirst();
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username, this.getFinantialInstitution());
    }
}

