/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.integration;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.fenixedu.treasury.domain.integration.OperationFileDomainObject$callable$delete;
import org.fenixedu.treasury.domain.integration.OperationFileDomainObject$callable$edit;
import org.fenixedu.treasury.domain.integration.OperationFileDomainObject_Base;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OperationFileDomainObject
extends OperationFileDomainObject_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public OperationFileDomainObject() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    @Override
    public boolean isAccessible(String username) {
        throw new RuntimeException("not implemented");
    }

    private void checkRules() {
    }

    public void edit() {
        Object object = advice$edit.perform((Callable)new OperationFileDomainObject$callable$edit(this));
    }

    static /* synthetic */ void advised$edit(OperationFileDomainObject this_) {
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new OperationFileDomainObject$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(OperationFileDomainObject this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.OperationFile.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setLogIntegrationOperation(null);
        this_.setIntegrationOperation(null);
        this_.setTreasuryFile(null);
        super.deleteDomainObject();
    }

    public static OperationFileDomainObject createFromOperationFile(OperationFile file) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        OperationFileDomainObject result = new OperationFileDomainObject();
        result.setIntegrationOperation(file.getIntegrationOperation());
        result.setLogIntegrationOperation(file.getLogIntegrationOperation());
        result.setCreationDate(file.getCreationDate());
        result.setCreator(services.versioningCreatorUsername(file));
        result.setTreasuryFile((TreasuryFile)((Object)file));
        result.setFileId(file.getExternalId());
        return result;
    }

    public static Stream<OperationFileDomainObject> findAll() {
        return FenixFramework.getDomainRoot().getOperationFileDomainObjectsSet().stream();
    }

    public static Optional<OperationFileDomainObject> findUniqueByOperationFile(OperationFile file) {
        return file.getOperationFileDomainObjectSet().stream().filter(o -> o.getTreasuryFile() == file).findFirst();
    }
}

