/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfigurationFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfigurationFileDomainObject_Base;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.fenixframework.FenixFramework;

public class ForwardPaymentConfigurationFileDomainObject
extends ForwardPaymentConfigurationFileDomainObject_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";

    protected ForwardPaymentConfigurationFileDomainObject() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isManager(username);
    }

    public static ForwardPaymentConfigurationFileDomainObject createFromForwardPaymentConfigurationFile(ForwardPaymentConfigurationFile file) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        ForwardPaymentConfigurationFileDomainObject result = new ForwardPaymentConfigurationFileDomainObject();
        result.setCreationDate(file.getCreationDate());
        result.setCreator(services.getLoggedUsername());
        result.setFileId(file.getExternalId());
        result.setTreasuryFile((TreasuryFile)((Object)file));
        return result;
    }

    public static Stream<ForwardPaymentConfigurationFileDomainObject> findAll() {
        return FenixFramework.getDomainRoot().getVirtualTPACertificateDomainObjectSet().stream();
    }

    public static Optional<ForwardPaymentConfigurationFileDomainObject> findUniqueFromForwardPaymentConfigurationFile(ForwardPaymentConfigurationFile file) {
        return ForwardPaymentConfigurationFileDomainObject.findAll().filter(o -> o.getTreasuryFile() == file).findFirst();
    }

    @Override
    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        this.setTreasuryFile(null);
        super.deleteDomainObject();
    }
}

