/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfigurationFileDomainObject;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfigurationFile_Base;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;

public class ForwardPaymentConfigurationFile
extends ForwardPaymentConfigurationFile_Base {
    protected ForwardPaymentConfigurationFile() {
        this.setBennu(Bennu.getInstance());
    }

    public boolean isAccessible(User arg0) {
        return this.isAccessible(arg0.getUsername());
    }

    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isManager(username);
    }

    public static ForwardPaymentConfigurationFile create(String filename, byte[] contents) {
        ForwardPaymentConfigurationFile file = new ForwardPaymentConfigurationFile();
        file.init(filename, filename, contents);
        ForwardPaymentConfigurationFileDomainObject.createFromForwardPaymentConfigurationFile(file);
        return file;
    }

    public static Stream<ForwardPaymentConfigurationFile> findAll() {
        return Bennu.getInstance().getVirtualTPACertificateSet().stream();
    }

    public void delete() {
        this.setBennu(null);
        ForwardPaymentConfigurationFileDomainObject.findUniqueFromForwardPaymentConfigurationFile(this).get().delete();
        super.delete();
    }
}

