/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.util.streaming.spreadsheet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;

public interface Spreadsheet {
    public static final int ROWS_IN_MEMORY = 100;

    public ExcelSheet[] getSheets();

    public static byte[] buildSpreadsheetContent(Spreadsheet spreadsheet, IErrorsLog errorsLog) {
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        for (ExcelSheet sheet : spreadsheet.getSheets()) {
            Sheet sh = wb.createSheet(sheet.getName());
            Row row = sh.createRow(0);
            Font headerFont = wb.createFont();
            headerFont.setBold(true);
            if (row.getRowStyle() == null) {
                row.setRowStyle(wb.createCellStyle());
            }
            row.getRowStyle().setFont(headerFont);
            String[] headers = sheet.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellType(1);
                cell.setCellValue(headers[i]);
            }
            sheet.getRows().forEach(r -> r.writeCellValues(sh.createRow(sh.getLastRowNum() + 1), errorsLog));
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return output.toByteArray();
    }
}

