/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.integration.erp;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.integration.erp.ERPExportOperationController;
import org.fenixedu.treasury.ui.integration.erp.FinantialDocumentController$callable$deleteFinantialDocument;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=ERPExportOperationController.class)
@RequestMapping(value={"/treasury/integration/erp/finantialdocument"})
public class FinantialDocumentController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/integration/erp/finantialdocument";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/integration/erp/finantialdocument/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/integration/erp/finantialdocument/search/view/";
    private static final String _SEARCH_TO_FORCEINTEGRATIONEXPORT_URI = "/search/forceintegrationexport";
    public static final String SEARCH_TO_FORCEINTEGRATIONEXPORT_URL = "/treasury/integration/erp/finantialdocument/search/forceintegrationexport";
    private static final String _SEARCH_TO_FORCECHECK_STATUS_URI = "/search/forcecheckstatus";
    public static final String _SEARCH_TO_FORCECHECK_STATUS_URL = "/treasury/integration/erp/finantialdocument/search/forcecheckstatus";
    private static final String _SEARCH_TO_MARK_MULTIPLE_EXPORTED_URI = "/search/markmultipleexported";
    public static final String SEARCH_TO_MARK_MULTIPLE_EXPORTED_URL = "/treasury/integration/erp/finantialdocument/search/markmultipleexported";
    private static final String _READ_FINANTIAL_DOCUMENT_URI = "/readfinantialdocument";
    public static final String READ_FINANTIAL_DOCUMENT_URL = "/treasury/integration/erp/finantialdocument/readfinantialdocument";
    public static final Advice advice$deleteFinantialDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/integration/erp/finantialdocument/";
    }

    private FinantialDocument getFinantialDocument(Model model) {
        return (FinantialDocument)((Object)model.asMap().get("finantialDocument"));
    }

    private void setFinantialDocument(FinantialDocument finantialDocument, Model model) {
        model.addAttribute("finantialDocument", (Object)finantialDocument);
    }

    public void deleteFinantialDocument(FinantialDocument finantialDocument) {
        Object object = advice$deleteFinantialDocument.perform((Callable)new FinantialDocumentController$callable$deleteFinantialDocument(this, finantialDocument));
    }

    static /* synthetic */ void advised$deleteFinantialDocument(FinantialDocumentController this_, FinantialDocument finantialDocument) {
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="finantialinstitution", required=false) FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        if (finantialInstitution == null) {
            finantialInstitution = FinantialInstitution.findAll().findFirst().orElse(null);
            return this.redirect("/treasury/integration/erp/finantialdocument/?finantialinstitution=" + finantialInstitution.getExternalId(), model, redirectAttributes);
        }
        Set<FinantialDocument> searchfinantialdocumentResultsDataSet = this.filterSearchFinantialDocument(finantialInstitution);
        model.addAttribute("searchfinantialdocumentResultsDataSet", searchfinantialdocumentResultsDataSet);
        model.addAttribute("FinantialDocument_finantialInstitution_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/integration/erp/finantialdocument/search";
    }

    private Set<FinantialDocument> filterSearchFinantialDocument(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getFinantialDocumentsPendingForExportationSet();
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") FinantialDocument finantialDocument, Model model, RedirectAttributes redirectAttributes) {
        if (finantialDocument.isDebitNote()) {
            return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + finantialDocument.getExternalId(), model, redirectAttributes);
        }
        if (finantialDocument.isCreditNote()) {
            return this.redirect("/treasury/document/manageinvoice/creditnote/read/" + finantialDocument.getExternalId(), model, redirectAttributes);
        }
        if (finantialDocument.isSettlementNote()) {
            return this.redirect("/treasury/document/managepayments/settlementnote/read/" + finantialDocument.getExternalId(), model, redirectAttributes);
        }
        this.addWarningMessage(TreasuryConstants.treasuryBundle("warning.integration.erp.invalid.document.type", new String[0]), model);
        return this.search(finantialDocument.getInstitutionForExportation(), model, redirectAttributes);
    }

    @RequestMapping(value={"/search/forceintegrationexport"})
    public String processSearchToForceIntegrationExport(@RequestParam(value="finantialinstitution", required=true) FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsManager(model);
            List<ERPExportOperation> exportPendingDocumentsForFinantialInstitution = ERPExporterManager.exportPendingDocumentsForFinantialInstitution(finantialInstitution);
            if (exportPendingDocumentsForFinantialInstitution.size() == 0) {
                this.addWarningMessage(TreasuryConstants.treasuryBundle("warning.integration.erp.no.documents.to.export", new String[0]), model);
                return this.redirect(SEARCH_URL, model, redirectAttributes);
            }
            if (exportPendingDocumentsForFinantialInstitution.size() == 1) {
                this.addInfoMessage(TreasuryConstants.treasuryBundle("info.integration.erp.success.export", new String[0]), model);
                return this.redirect("/treasury/integration/erp/erpexportoperation/read/" + exportPendingDocumentsForFinantialInstitution.get(0).getExternalId(), model, redirectAttributes);
            }
            this.addInfoMessage(TreasuryConstants.treasuryBundle("info.integration.erp.multiple.success.export", new String[0]), model);
            return this.redirect("/treasury/integration/erp/erpexportoperation/", model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getMessage(), model);
            return this.search(finantialInstitution, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/search/forcecheckstatus"})
    public String processSearchToForceCehckStatus(@RequestParam(value="finantialinstitution", required=true) FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            ERPExporterManager.requestPendingDocumentStatus(finantialInstitution);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getMessage(), model);
        }
        return this.search(finantialInstitution, model, redirectAttributes);
    }

    @RequestMapping(value={"/search/markmultipleexported"}, method={RequestMethod.POST})
    public String processSearchToMarkMultipleAsExported(@RequestParam(value="document") List<FinantialDocument> finantialDocuments, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsManager(model);
            for (FinantialDocument finantialDocument : finantialDocuments) {
            }
            this.addInfoMessage(TreasuryConstants.treasuryBundle("label.success.create", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + ex.getLocalizedMessage(), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/readfinantialdocument/{id}"}, method={RequestMethod.GET})
    public String readfinantialdocument(@PathVariable(value="id") FinantialDocument finantialDocument, Model model, RedirectAttributes redirectAttributes) {
        if (finantialDocument.isDebitNote()) {
            return this.redirect("/treasury/document/manageinvoice/debitnote/read//" + finantialDocument.getExternalId(), model, redirectAttributes);
        }
        if (finantialDocument.isCreditNote()) {
            return this.redirect("/treasury/document/manageinvoice/creditnote/read//" + finantialDocument.getExternalId(), model, redirectAttributes);
        }
        if (finantialDocument.isSettlementNote()) {
            return this.redirect("/treasury/document/managepayments/settlementnote/read//" + finantialDocument.getExternalId(), model, redirectAttributes);
        }
        return null;
    }
}

