/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managesibsinputfile;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.payments.sibs.managesibsinputfile.SibsInputFileController$callable$createSibsInputFile;
import org.fenixedu.treasury.ui.administration.payments.sibs.managesibsinputfile.SibsInputFileController$callable$deleteSibsInputFile;
import org.fenixedu.treasury.ui.administration.payments.sibs.managesibsinputfile.SibsInputFileController$callable$updateSibsInputFile;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.payments.sibs.manageSibsInputFile", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile"})
public class SibsInputFileController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/create";
    private static final String _PROCESS_URI = "/read/process/";
    public static final String PROCESS_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/read/process/";
    private static final String _DOWNLOAD_URI = "/read/download/";
    public static final String DOWNLOAD_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/read/download/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/update/";
    public static final Advice advice$deleteSibsInputFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createSibsInputFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateSibsInputFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/";
    }

    private SibsInputFile getSibsInputFile(Model model) {
        return (SibsInputFile)((Object)model.asMap().get("sibsInputFile"));
    }

    private void setSibsInputFile(SibsInputFile sibsInputFile, Model model) {
        model.addAttribute("sibsInputFile", (Object)sibsInputFile);
    }

    public void deleteSibsInputFile(SibsInputFile sibsInputFile) {
        Object object = advice$deleteSibsInputFile.perform((Callable)new SibsInputFileController$callable$deleteSibsInputFile(this, sibsInputFile));
    }

    static /* synthetic */ void advised$deleteSibsInputFile(SibsInputFileController this_, SibsInputFile sibsInputFile) {
        sibsInputFile.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="whenprocessedbysibs", required=false) @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") LocalDate whenProcessedBySibs, Model model) {
        List<SibsInputFile> searchsibsinputfileResultsDataSet = this.filterSearchSibsInputFile(whenProcessedBySibs);
        model.addAttribute("searchsibsinputfileResultsDataSet", searchsibsinputfileResultsDataSet);
        Boolean brokerActive = FinantialInstitution.findAll().map(f -> f.getSibsConfiguration().isPaymentsBrokerActive()).reduce((a, c) -> a != false || c != false).orElse(Boolean.FALSE);
        model.addAttribute("brokerActive", (Object)brokerActive);
        return "treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/search";
    }

    private Stream<SibsInputFile> getSearchUniverseSearchSibsInputFileDataSet() {
        return SibsInputFile.findAll();
    }

    private List<SibsInputFile> filterSearchSibsInputFile(LocalDate whenProcessedBySibs) {
        return this.getSearchUniverseSearchSibsInputFileDataSet().filter(sibsInputFile -> whenProcessedBySibs == null || whenProcessedBySibs.equals((Object)sibsInputFile.getWhenProcessedBySibs())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") SibsInputFile sibsInputFile, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + sibsInputFile.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") SibsInputFile sibsInputFile, Model model) {
        this.setSibsInputFile(sibsInputFile, model);
        return "treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") SibsInputFile sibsInputFile, Model model, RedirectAttributes redirectAttributes) {
        this.setSibsInputFile(sibsInputFile, model);
        try {
            this.assertUserIsManager(model);
            this.deleteSibsInputFile(sibsInputFile);
            this.addInfoMessage(TreasuryConstants.treasuryBundle("label.success.delete", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getSibsInputFile(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="whenprocessedbysibs", required=false) @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") DateTime whenProcessedBySibs, @RequestParam(value="documentSibsInputFile", required=true) MultipartFile documentSibsInputFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(model);
            SibsInputFile sibsInputFile = this.createSibsInputFile(whenProcessedBySibs, documentSibsInputFile);
            if (sibsInputFile.getWhenProcessedBySibs().compareTo((ReadableInstant)whenProcessedBySibs) != 0) {
                this.addWarningMessage(TreasuryConstants.treasuryBundle("warning.SibsInputFileController.whenprocessedbysibs.different.in.file", sibsInputFile.getWhenProcessedBySibs().toString()), model);
            }
            model.addAttribute("sibsInputFile", (Object)sibsInputFile);
            return this.redirect(READ_URL + this.getSibsInputFile(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public SibsInputFile createSibsInputFile(DateTime dateTime, MultipartFile multipartFile) {
        return (SibsInputFile)((Object)advice$createSibsInputFile.perform((Callable)new SibsInputFileController$callable$createSibsInputFile(this, dateTime, multipartFile)));
    }

    static /* synthetic */ SibsInputFile advised$createSibsInputFile(SibsInputFileController this_, DateTime whenProcessedBySibs, MultipartFile documentSibsInputFile) {
        PaymentCodePool pool = null;
        try {
            SibsIncommingPaymentFile file = SibsIncommingPaymentFile.parse(documentSibsInputFile.getOriginalFilename(), documentSibsInputFile.getInputStream());
            if (file.getHeader().getWhenProcessedBySibs().toDateTimeAtMidnight().compareTo((ReadableInstant)whenProcessedBySibs) != 0) {
                whenProcessedBySibs = file.getHeader().getWhenProcessedBySibs().toDateTimeAtMidnight();
            }
            String entityCode = file.getHeader().getEntityCode();
            pool = PaymentCodePool.findByEntityCode(entityCode).findFirst().orElse(null);
        }
        catch (IOException e) {
            throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile", e.getLocalizedMessage());
        }
        catch (RuntimeException ex) {
            throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile", ex.getLocalizedMessage());
        }
        if (pool == null) {
            throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile.poolNull", new String[0]);
        }
        SibsInputFile sibsInputFile = SibsInputFile.create(pool.getFinantialInstitution(), whenProcessedBySibs, documentSibsInputFile.getName(), documentSibsInputFile.getOriginalFilename(), this_.getContent(documentSibsInputFile), TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
        return sibsInputFile;
    }

    @RequestMapping(value={"/read/process/{oid}"}, method={RequestMethod.POST})
    public String processReadToProcessFile(@PathVariable(value="oid") SibsInputFile sibsInputFile, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setSibsInputFile(sibsInputFile, model);
        try {
            this.assertUserIsFrontOfficeMember(sibsInputFile.getFinantialInstitution(), model);
            SIBSPaymentsImporter importer = new SIBSPaymentsImporter();
            SibsReportFile reportFile = null;
            try {
                SIBSPaymentsImporter.ProcessResult result = importer.processSIBSPaymentFiles(sibsInputFile);
                if (result.getErrorMessages().isEmpty()) {
                    this.addInfoMessage(TreasuryConstants.treasuryBundle("label.success.upload", new String[0]), model);
                } else {
                    this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.upload", new String[0]), model);
                }
                reportFile = result.getReportFile();
                if (result.getReportFile() == null) {
                    return this.redirect(READ_URL + sibsInputFile.getExternalId(), model, redirectAttributes);
                }
                reportFile.updateLogMessages(result);
            }
            catch (IOException e) {
                throw new TreasuryDomainException("error.SibsInputFile.error.processing.sibs.input.file", new String[0]);
            }
            return this.redirect("/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/read/" + reportFile.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(READ_URL + sibsInputFile.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/download/{oid}"}, method={RequestMethod.GET})
    public void processReadToDownloadFile(@PathVariable(value="oid") SibsInputFile sibsInputFile, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setSibsInputFile(sibsInputFile, model);
        try {
            this.assertUserIsFrontOfficeMember(sibsInputFile.getFinantialInstitution(), model);
            response.setContentType(sibsInputFile.getContentType());
            String filename = sibsInputFile.getFilename();
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(sibsInputFile.getContent());
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + this.getSibsInputFile(model).getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private byte[] getContent(MultipartFile requestFile) {
        try {
            return requestFile.getBytes();
        }
        catch (IOException e) {
            return null;
        }
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") SibsInputFile sibsInputFile, Model model) {
        this.setSibsInputFile(sibsInputFile, model);
        return "treasury/administration/payments/sibs/managesibsinputfile/sibsinputfile/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") SibsInputFile sibsInputFile, @RequestParam(value="whenprocessedbysibs", required=false) @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") DateTime whenProcessedBySibs, @RequestParam(value="transactionstotalamount", required=false) BigDecimal transactionsTotalAmount, @RequestParam(value="totalcost", required=false) BigDecimal totalCost, Model model, RedirectAttributes redirectAttributes) {
        this.setSibsInputFile(sibsInputFile, model);
        try {
            this.assertUserIsFrontOfficeMember(sibsInputFile.getFinantialInstitution(), model);
            this.updateSibsInputFile(whenProcessedBySibs, transactionsTotalAmount, totalCost, model);
            return this.redirect(READ_URL + this.getSibsInputFile(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(sibsInputFile, model);
    }

    public void updateSibsInputFile(DateTime dateTime, BigDecimal bigDecimal, BigDecimal bigDecimal2, Model model) {
        Object object = advice$updateSibsInputFile.perform((Callable)new SibsInputFileController$callable$updateSibsInputFile(this, dateTime, bigDecimal, bigDecimal2, model));
    }

    static /* synthetic */ void advised$updateSibsInputFile(SibsInputFileController this_, DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, Model model) {
        this_.getSibsInputFile(model).setWhenProcessedBySibs(whenProcessedBySibs);
    }
}

