/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.document.managefinantialdocumenttype;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.document.managefinantialdocumenttype.FinantialDocumentTypeController$callable$createFinantialDocumentType;
import org.fenixedu.treasury.ui.administration.document.managefinantialdocumenttype.FinantialDocumentTypeController$callable$deleteFinantialDocumentType;
import org.fenixedu.treasury.ui.administration.document.managefinantialdocumenttype.FinantialDocumentTypeController$callable$updateFinantialDocumentType;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.document.manageFinantialDocumentType", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype"})
public class FinantialDocumentTypeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/delete/";
    public static final Advice advice$deleteFinantialDocumentType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createFinantialDocumentType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateFinantialDocumentType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/";
    }

    private FinantialDocumentType getFinantialDocumentType(Model model) {
        return (FinantialDocumentType)((Object)model.asMap().get("finantialDocumentType"));
    }

    private void setFinantialDocumentType(FinantialDocumentType finantialDocumentType, Model model) {
        model.addAttribute("finantialDocumentType", (Object)finantialDocumentType);
    }

    public void deleteFinantialDocumentType(FinantialDocumentType finantialDocumentType) {
        Object object = advice$deleteFinantialDocumentType.perform((Callable)new FinantialDocumentTypeController$callable$deleteFinantialDocumentType(this, finantialDocumentType));
    }

    static /* synthetic */ void advised$deleteFinantialDocumentType(FinantialDocumentTypeController this_, FinantialDocumentType finantialDocumentType) {
        finantialDocumentType.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="type", required=false) FinantialDocumentTypeEnum type, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="documentnumberseriesprefix", required=false) String documentNumberSeriesPrefix, @RequestParam(value="invoice", required=false) boolean invoice, Model model) {
        List<FinantialDocumentType> searchfinantialdocumenttypeResultsDataSet = this.filterSearchFinantialDocumentType(type, code, name, documentNumberSeriesPrefix, invoice);
        model.addAttribute("searchfinantialdocumenttypeResultsDataSet", searchfinantialdocumenttypeResultsDataSet);
        model.addAttribute("typeValues", (Object)FinantialDocumentTypeEnum.values());
        return "treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/search";
    }

    private List<FinantialDocumentType> getSearchUniverseSearchFinantialDocumentTypeDataSet() {
        return FinantialDocumentType.findAll().collect(Collectors.toList());
    }

    private List<FinantialDocumentType> filterSearchFinantialDocumentType(FinantialDocumentTypeEnum type, String code, LocalizedString name, String documentNumberSeriesPrefix, boolean invoice) {
        return this.getSearchUniverseSearchFinantialDocumentTypeDataSet().stream().collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") FinantialDocumentType finantialDocumentType, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + finantialDocumentType.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") FinantialDocumentType finantialDocumentType, Model model) {
        this.setFinantialDocumentType(finantialDocumentType, model);
        return "treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") FinantialDocumentType finantialDocumentType, Model model, RedirectAttributes redirectAttributes) {
        this.setFinantialDocumentType(finantialDocumentType, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteFinantialDocumentType(finantialDocumentType);
            this.addInfoMessage(TreasuryConstants.treasuryBundle("label.success.delete", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getFinantialDocumentType(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("typeValues", (Object)FinantialDocumentTypeEnum.values());
        model.addAttribute("FinantialDocumentType_bennu_options", new ArrayList());
        return "treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="type", required=false) FinantialDocumentTypeEnum type, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="documentnumberseriesprefix", required=false) String documentNumberSeriesPrefix, @RequestParam(value="invoice", required=false) boolean invoice, @RequestParam(value="bennu", required=false) Bennu bennu, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            FinantialDocumentType finantialDocumentType = this.createFinantialDocumentType(type, code, name, documentNumberSeriesPrefix, invoice, bennu);
            model.addAttribute("finantialDocumentType", (Object)finantialDocumentType);
            return this.redirect(READ_URL + this.getFinantialDocumentType(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + de.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public FinantialDocumentType createFinantialDocumentType(FinantialDocumentTypeEnum finantialDocumentTypeEnum, String string, LocalizedString localizedString, String string2, boolean bl, Bennu bennu) {
        return (FinantialDocumentType)((Object)advice$createFinantialDocumentType.perform((Callable)new FinantialDocumentTypeController$callable$createFinantialDocumentType(this, finantialDocumentTypeEnum, string, localizedString, string2, bl, bennu)));
    }

    static /* synthetic */ FinantialDocumentType advised$createFinantialDocumentType(FinantialDocumentTypeController this_, FinantialDocumentTypeEnum type, String code, LocalizedString name, String documentNumberSeriesPrefix, boolean invoice, Bennu bennu) {
        FinantialDocumentType finantialDocumentType = null;
        switch (type) {
            case CREDIT_NOTE: {
                finantialDocumentType = FinantialDocumentType.createForCreditNote(code, name, documentNumberSeriesPrefix, invoice);
                break;
            }
            case REIMBURSEMENT_NOTE: {
                finantialDocumentType = FinantialDocumentType.createForReimbursementNote(code, name, documentNumberSeriesPrefix, invoice);
                break;
            }
            case DEBIT_NOTE: {
                finantialDocumentType = FinantialDocumentType.createForDebitNote(code, name, documentNumberSeriesPrefix, invoice);
                break;
            }
            case SETTLEMENT_NOTE: {
                finantialDocumentType = FinantialDocumentType.createForSettlementNote(code, name, documentNumberSeriesPrefix, invoice);
            }
        }
        return finantialDocumentType;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") FinantialDocumentType finantialDocumentType, Model model) {
        this.setFinantialDocumentType(finantialDocumentType, model);
        return "treasury/administration/document/managefinantialdocumenttype/finantialdocumenttype/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") FinantialDocumentType finantialDocumentType, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        this.setFinantialDocumentType(finantialDocumentType, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateFinantialDocumentType(code, name, model);
            return this.redirect(READ_URL + this.getFinantialDocumentType(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + de.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(finantialDocumentType, model);
    }

    public void updateFinantialDocumentType(String string, LocalizedString localizedString, Model model) {
        Object object = advice$updateFinantialDocumentType.perform((Callable)new FinantialDocumentTypeController$callable$updateFinantialDocumentType(this, string, localizedString, model));
    }

    static /* synthetic */ void advised$updateFinantialDocumentType(FinantialDocumentTypeController this_, String code, LocalizedString name, Model model) {
        this_.getFinantialDocumentType(model).edit(code, name);
    }
}

