/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managevattype;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.managevattype.VatTypeController$callable$createVatType;
import org.fenixedu.treasury.ui.administration.base.managevattype.VatTypeController$callable$deleteVatType;
import org.fenixedu.treasury.ui.administration.base.managevattype.VatTypeController$callable$updateVatType;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageVatType", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/managevattype/vattype"})
public class VatTypeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managevattype/vattype";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/managevattype/vattype/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managevattype/vattype/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managevattype/vattype/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managevattype/vattype/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managevattype/vattype/delete/";
    public static final Advice advice$deleteVatType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createVatType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateVatType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managevattype/vattype/";
    }

    private VatType getVatType(Model m) {
        return (VatType)((Object)m.asMap().get("vatType"));
    }

    private void setVatType(VatType vatType, Model m) {
        m.addAttribute("vatType", (Object)vatType);
    }

    public void deleteVatType(VatType vatType) {
        Object object = advice$deleteVatType.perform((Callable)new VatTypeController$callable$deleteVatType(this, vatType));
    }

    static /* synthetic */ void advised$deleteVatType(VatTypeController this_, VatType vatType) {
        vatType.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model) {
        List<VatType> searchvattypeResultsDataSet = this.filterSearchVatType(code, name);
        model.addAttribute("searchvattypeResultsDataSet", searchvattypeResultsDataSet);
        return "treasury/administration/base/managevattype/vattype/search";
    }

    private Stream<VatType> getSearchUniverseSearchVatTypeDataSet() {
        return VatType.findAll();
    }

    private List<VatType> filterSearchVatType(String code, LocalizedString name) {
        return this.getSearchUniverseSearchVatTypeDataSet().filter(vatType -> code == null || code.length() == 0 || vatType.getCode() != null && vatType.getCode().length() > 0 && vatType.getCode().toLowerCase().contains(code.toLowerCase())).filter(vatType -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> vatType.getName().getContent(locale) != null && vatType.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") VatType vatType, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + vatType.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") VatType vatType, Model model) {
        this.setVatType(vatType, model);
        return "treasury/administration/base/managevattype/vattype/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") VatType vatType, Model model, RedirectAttributes redirectAttributes) {
        this.setVatType(vatType, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteVatType(vatType);
            this.addInfoMessage(TreasuryConstants.treasuryBundle("label.success.delete", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getVatType(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/managevattype/vattype/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            VatType vatType = this.createVatType(code, name);
            model.addAttribute("vatType", (Object)vatType);
            return this.redirect(READ_URL + this.getVatType(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + de.getLocalizedMessage(), model);
            return this.create(model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + de.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    public VatType createVatType(String string, LocalizedString localizedString) {
        return (VatType)((Object)advice$createVatType.perform((Callable)new VatTypeController$callable$createVatType(this, string, localizedString)));
    }

    static /* synthetic */ VatType advised$createVatType(VatTypeController this_, String code, LocalizedString name) {
        VatType vatType = VatType.create(code, name);
        return vatType;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") VatType vatType, Model model) {
        this.setVatType(vatType, model);
        return "treasury/administration/base/managevattype/vattype/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") VatType vatType, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        this.setVatType(vatType, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateVatType(code, name, model);
            return this.redirect(READ_URL + this.getVatType(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + de.getLocalizedMessage(), model);
            return this.update(vatType, model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + de.getLocalizedMessage(), model);
            return this.update(vatType, model);
        }
    }

    public void updateVatType(String string, LocalizedString localizedString, Model model) {
        Object object = advice$updateVatType.perform((Callable)new VatTypeController$callable$updateVatType(this, string, localizedString, model));
    }

    static /* synthetic */ void advised$updateVatType(VatTypeController this_, String code, LocalizedString name, Model m) {
        this_.getVatType(m).setCode(code);
        this_.getVatType(m).setName(name);
    }
}

