/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managevat;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.managevat.VatController$callable$createVat;
import org.fenixedu.treasury.ui.administration.base.managevat.VatController$callable$deleteVat;
import org.fenixedu.treasury.ui.administration.base.managevat.VatController$callable$updateVat;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageVat", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/managevat/vat"})
public class VatController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managevat/vat";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/managevat/vat/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managevat/vat/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managevat/vat/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managevat/vat/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managevat/vat/delete/";
    public static final Advice advice$deleteVat = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createVat = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateVat = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managevat/vat/";
    }

    private Vat getVat(Model m) {
        return (Vat)((Object)m.asMap().get("vat"));
    }

    private void setVat(Vat vat, Model m) {
        m.addAttribute("vat", (Object)vat);
    }

    public void deleteVat(Vat vat) {
        Object object = advice$deleteVat.perform((Callable)new VatController$callable$deleteVat(this, vat));
    }

    static /* synthetic */ void advised$deleteVat(VatController this_, Vat vat) {
        vat.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="vatType", required=false) VatType vatType, @RequestParam(value="finantialInstitution", required=false) FinantialInstitution finantialInstitution, @RequestParam(value="onlyActive", required=false) Boolean onlyActive, Model model) {
        List<Vat> searchvatResultsDataSet = this.filterSearchVat(vatType, finantialInstitution, onlyActive);
        model.addAttribute("vatTypeList", VatType.findAll().collect(Collectors.toList()));
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        this.checkVatRules(model);
        model.addAttribute("searchvatResultsDataSet", searchvatResultsDataSet);
        return "treasury/administration/base/managevat/vat/search";
    }

    private void checkVatRules(Model model) {
        FinantialInstitution.findAll().forEach(inst -> VatType.findAll().forEach(vatType -> {
            if (!Vat.findActiveUnique(vatType, inst, new DateTime()).isPresent()) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle("label.Vat.missing.vattype.for", inst.getName(), vatType.getName().getContent()), model);
            }
        }));
    }

    private Set<Vat> getSearchUniverseSearchVatDataSet() {
        return Vat.findAll().collect(Collectors.toSet());
    }

    private List<Vat> filterSearchVat(VatType vatType, FinantialInstitution finantialInstitution, Boolean onlyActive) {
        return this.getSearchUniverseSearchVatDataSet().stream().filter(x -> finantialInstitution == null || finantialInstitution.equals(x.getFinantialInstitution())).filter(x -> vatType == null || vatType.equals((Object)x.getVatType())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") Vat vat, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + vat.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") Vat vat, Model model) {
        this.setVat(vat, model);
        return "treasury/administration/base/managevat/vat/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") Vat vat, Model model, RedirectAttributes redirectAttributes) {
        this.setVat(vat, model);
        try {
            this.assertUserIsBackOfficeMember(vat.getFinantialInstitution(), model);
            this.deleteVat(vat);
            this.addInfoMessage(TreasuryConstants.treasuryBundle("label.success.delete", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getVat(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("vatTypeList", VatType.findAll().collect(Collectors.toList()));
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/administration/base/managevat/vat/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="vatType", required=false) VatType vatType, @RequestParam(value="finantialInstitution", required=false) FinantialInstitution finantialInstitution, @RequestParam(value="taxrate", required=false) BigDecimal taxRate, @RequestParam(value="begindate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime beginDate, @RequestParam(value="enddate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime endDate, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            Vat vat = this.createVat(vatType, finantialInstitution, taxRate, beginDate, endDate);
            model.addAttribute("vat", (Object)vat);
            return this.redirect(READ_URL + this.getVat(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + de.getLocalizedMessage(), model);
            return this.create(model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.create", new String[0]) + de.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    public Vat createVat(VatType vatType, FinantialInstitution finantialInstitution, BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2) {
        return (Vat)((Object)advice$createVat.perform((Callable)new VatController$callable$createVat(this, vatType, finantialInstitution, bigDecimal, dateTime, dateTime2)));
    }

    static /* synthetic */ Vat advised$createVat(VatController this_, VatType vatType, FinantialInstitution finantialInstitution, BigDecimal taxRate, DateTime beginDate, DateTime endDate) {
        Vat vat = Vat.create(vatType, finantialInstitution, taxRate, beginDate, endDate);
        return vat;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") Vat vat, Model model) {
        this.setVat(vat, model);
        model.addAttribute("vatTypeList", VatType.findAll().collect(Collectors.toList()));
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/administration/base/managevat/vat/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") Vat vat, @RequestParam(value="taxrate", required=false) BigDecimal taxRate, @RequestParam(value="begindate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime beginDate, @RequestParam(value="enddate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime endDate, Model model, RedirectAttributes redirectAttributes) {
        this.setVat(vat, model);
        try {
            this.assertUserIsBackOfficeMember(vat.getFinantialInstitution(), model);
            this.updateVat(taxRate, beginDate, endDate, model);
            return this.redirect(READ_URL + this.getVat(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + de.getLocalizedMessage(), model);
            return this.update(vat, model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle("label.error.update", new String[0]) + de.getLocalizedMessage(), model);
            return this.update(vat, model);
        }
    }

    public void updateVat(BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2, Model model) {
        Object object = advice$updateVat.perform((Callable)new VatController$callable$updateVat(this, bigDecimal, dateTime, dateTime2, model));
    }

    static /* synthetic */ void advised$updateVat(VatController this_, BigDecimal taxRate, DateTime beginDate, DateTime endDate, Model m) {
        this_.getVat(m).edit(taxRate, beginDate, endDate);
    }
}

