/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs.incomming;

import java.io.IOException;
import java.util.stream.Collectors;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.services.payments.sibs.SibsPaymentsBrokerService;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.joda.time.LocalDate;

@Task(englishTitle="Process SIBS payments from broker", readOnly=false)
public class ProcessSibsPaymentsFromBroker
extends CronTask {
    public void runTask() throws Exception {
        LocalDate now = new LocalDate();
        for (int i = 3; i > 0; --i) {
            this.importFromBroker(now.minusDays(i * 3), now.minusDays(i * 3 - 2));
        }
        this.importFromBroker(now, now);
    }

    private void importFromBroker(LocalDate fromDate, LocalDate toDate) throws IOException {
        this.taskLog(String.format("[%s - %s] Processing...\n", fromDate.toString("yyyy/MM/dd"), toDate.toString("yyyy/MM/dd")), new Object[0]);
        for (FinantialInstitution finantialInstitution : FinantialInstitution.findAll().collect(Collectors.toSet())) {
            if (!finantialInstitution.getSibsConfiguration().isPaymentsBrokerActive()) continue;
            for (PaymentCodePool paymentCodePool : finantialInstitution.getPaymentCodePoolsSet()) {
                try {
                    SibsIncommingPaymentFile sibsFile;
                    if (paymentCodePool.getActive() == null || !paymentCodePool.getActive().booleanValue() || (sibsFile = SibsPaymentsBrokerService.readPaymentsFromBroker(paymentCodePool.getFinantialInstitution(), fromDate, toDate, true, true)).getDetailLines().isEmpty()) continue;
                    SIBSPaymentsImporter importer = new SIBSPaymentsImporter();
                    SibsReportFile reportFile = null;
                    SIBSPaymentsImporter.ProcessResult result = importer.processSIBSPaymentFiles(sibsFile, paymentCodePool.getFinantialInstitution());
                    reportFile = result.getReportFile();
                    if (result.getReportFile() == null) continue;
                    reportFile.updateLogMessages(result);
                }
                catch (TreasuryDomainException e) {
                    if ("error.SibsPaymentsBrokerService.no.payments.to.import".equals(e.getMessage())) {
                        this.taskLog(String.format("[%s - %s] No payments to register\n", fromDate.toString("yyyy/MM/dd"), toDate.toString("yyyy/MM/dd")), new Object[0]);
                        continue;
                    }
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }
        this.taskLog(String.format("[%s - %s] Finished.\n", fromDate.toString("yyyy/MM/dd"), toDate.toString("yyyy/MM/dd")), new Object[0]);
    }
}

