/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paymentscodegenerator;

import java.math.BigDecimal;

public class CheckISO7064Mod97_10 {
    public String encode(String digits) {
        int c = this.computeCheck(digits);
        if (c == 0) {
            return digits + "00";
        }
        if (c < 10) {
            return digits + '0' + c;
        }
        return digits + c;
    }

    public boolean verify(String digits) {
        return Long.parseLong(digits) % 97L == 1L;
    }

    public int computeCheck(String digits) {
        BigDecimal remainder97 = new BigDecimal(digits).multiply(BigDecimal.valueOf(100L)).remainder(BigDecimal.valueOf(97L));
        BigDecimal sub98 = BigDecimal.valueOf(98L).subtract(remainder97);
        int value = sub98.remainder(BigDecimal.valueOf(97L)).intValue();
        if (value == 0) {
            return 97;
        }
        if (value == 1) {
            return 98;
        }
        return value;
    }

    public int getCheckDigit(String digits) {
        return Integer.parseInt(digits.substring(digits.length() - 2));
    }

    public String getData(String digits) {
        return digits.substring(0, digits.length() - 2);
    }
}

