/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$createSibsInputFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFileDomainObject;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsInputFile
extends SibsInputFile_Base {
    public static final String CONTENT_TYPE = "text/plain";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createSibsInputFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected SibsInputFile() {
        this.setBennu(Bennu.getInstance());
    }

    protected SibsInputFile(FinantialInstitution finantialInstitution, DateTime whenProcessedBySIBS, String displayName, String filename, byte[] content, String uploader) {
        this();
        this.init(finantialInstitution, whenProcessedBySIBS, displayName, filename, content, uploader);
        SibsInputFileDomainObject.createFromSibsInputFile(this);
    }

    protected void init(FinantialInstitution finantialInstitution, DateTime whenProcessedBySIBS, String displayName, String filename, byte[] content, String uploader) {
        super.init(displayName, filename, content);
        this.setWhenProcessedBySibs(whenProcessedBySIBS);
        this.setUploaderUsername(uploader);
        this.setFinantialInstitution(finantialInstitution);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit() {
        Object object = advice$edit.perform((Callable)new SibsInputFile$callable$edit(this));
    }

    static /* synthetic */ void advised$edit(SibsInputFile this_) {
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsInputFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsInputFile this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SibsInputFile.cannot.delete", new String[0]);
        }
        this_.setFinantialInstitution(null);
        this_.setBennu(null);
        SibsInputFileDomainObject.findUniqueBySibsInputFile(this_).get().delete();
        super.delete();
    }

    public static SibsInputFile create(FinantialInstitution finantialInstitution, DateTime dateTime, String string, String string2, byte[] byArray, String string3) {
        return (SibsInputFile)((Object)advice$create.perform((Callable)new SibsInputFile$callable$create(finantialInstitution, dateTime, string, string2, byArray, string3)));
    }

    static /* synthetic */ SibsInputFile advised$create(FinantialInstitution finantialInstitution, DateTime whenProcessedBySIBS, String displayName, String filename, byte[] content, String uploader) {
        return new SibsInputFile(finantialInstitution, whenProcessedBySIBS, displayName, filename, content, uploader);
    }

    public static SibsInputFile createSibsInputFile(DateTime dateTime, String string, String string2, byte[] byArray) {
        return (SibsInputFile)((Object)advice$createSibsInputFile.perform((Callable)new SibsInputFile$callable$createSibsInputFile(dateTime, string, string2, byArray)));
    }

    static /* synthetic */ SibsInputFile advised$createSibsInputFile(DateTime whenProcessedBySibs, String originalSibsFilename, String sibsName, byte[] sibsContent) {
        PaymentCodePool pool = null;
        try {
            String entityCode;
            SibsIncommingPaymentFile file = SibsIncommingPaymentFile.parse(originalSibsFilename, sibsContent);
            if (file.getHeader().getWhenProcessedBySibs().toDateTimeAtMidnight().compareTo((ReadableInstant)whenProcessedBySibs) != 0) {
                whenProcessedBySibs = file.getHeader().getWhenProcessedBySibs().toDateTimeAtMidnight();
            }
            if ((pool = (PaymentCodePool)PaymentCodePool.findByEntityCode(entityCode = file.getHeader().getEntityCode()).findFirst().orElse(null)) == null) {
                throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile.poolNull", new String[0]);
            }
            SibsInputFile sibsInputFile = SibsInputFile.create(pool.getFinantialInstitution(), whenProcessedBySibs, sibsName, originalSibsFilename, sibsContent, TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
            return sibsInputFile;
        }
        catch (RuntimeException ex) {
            throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile", ex.getLocalizedMessage());
        }
    }

    public static Stream<SibsInputFile> findAll() {
        HashSet result = new HashSet();
        for (FinantialInstitution finantialInstitution : FinantialInstitution.findAll().collect(Collectors.toList())) {
            result.addAll(finantialInstitution.getSibsInputFilesSet());
        }
        return result.stream();
    }

    public boolean isAccessible(User arg0) {
        return true;
    }

    public boolean isAccessible(String username) {
        return true;
    }
}

