/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.forwardpayments.PostForwardPaymentsReportFile;
import org.fenixedu.treasury.domain.forwardpayments.PostForwardPaymentsReportFileDomainObject_Base;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class PostForwardPaymentsReportFileDomainObject
extends PostForwardPaymentsReportFileDomainObject_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";

    private PostForwardPaymentsReportFileDomainObject() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    private PostForwardPaymentsReportFileDomainObject(DateTime postForwardPaymentsExecutionDate, DateTime beginDate, DateTime endDate, String filename, byte[] content) {
        this();
        this.setPostForwardPaymentsExecutionDate(postForwardPaymentsExecutionDate);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.createFile(this, filename, CONTENT_TYPE, content);
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username);
    }

    @Override
    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        super.deleteDomainObject();
    }

    public static Stream<PostForwardPaymentsReportFileDomainObject> findAll() {
        return FenixFramework.getDomainRoot().getPostForwardPaymentsReportFileDomainObjectsSet().stream();
    }

    public static Optional<PostForwardPaymentsReportFileDomainObject> findUniqueByPostForwardPaymentsReportFile(PostForwardPaymentsReportFile file) {
        return PostForwardPaymentsReportFileDomainObject.findAll().filter(o -> o.getTreasuryFile() == file).findFirst();
    }

    public static PostForwardPaymentsReportFileDomainObject createFromPostForwardPaymentsReportFile(PostForwardPaymentsReportFile file) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        PostForwardPaymentsReportFileDomainObject result = new PostForwardPaymentsReportFileDomainObject();
        result.setPostForwardPaymentsExecutionDate(file.getPostForwardPaymentsExecutionDate());
        result.setBeginDate(file.getBeginDate());
        result.setEndDate(file.getEndDate());
        result.setTreasuryFile((TreasuryFile)((Object)file));
        result.setCreationDate(file.getCreationDate());
        result.setCreator(services.versioningCreatorUsername(file));
        result.setFileId(file.getExternalId());
        return result;
    }
}

