/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentLogFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentLogFileDomainObject_Base;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.fenixframework.FenixFramework;

public class ForwardPaymentLogFileDomainObject
extends ForwardPaymentLogFileDomainObject_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";

    private ForwardPaymentLogFileDomainObject() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username);
    }

    public String getContentAsString() {
        if (this.getContent() != null) {
            return new String(this.getContent());
        }
        return null;
    }

    @Override
    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        this.setForwardPaymentLogsForRequest(null);
        this.setForwardPaymentLogsForResponse(null);
    }

    public static ForwardPaymentLogFileDomainObject createFromForwardPaymentLogFile(ForwardPaymentLogFile file) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        ForwardPaymentLogFileDomainObject result = new ForwardPaymentLogFileDomainObject();
        result.setForwardPaymentLogsForRequest(file.getForwardPaymentLogsForRequest());
        result.setForwardPaymentLogsForResponse(file.getForwardPaymentLogsForResponse());
        result.setTreasuryFile((TreasuryFile)((Object)file));
        result.setCreationDate(file.getCreationDate());
        result.setCreator(services.versioningCreatorUsername(file));
        result.setFileId(file.getExternalId());
        return result;
    }

    public static Stream<ForwardPaymentLogFileDomainObject> findAll() {
        return FenixFramework.getDomainRoot().getForwardPaymentLogFileDomainObjectsSet().stream();
    }

    public static Optional<ForwardPaymentLogFileDomainObject> findUniqueByForwardPaymentLogFile(ForwardPaymentLogFile file) {
        return ForwardPaymentLogFileDomainObject.findAll().filter(o -> o.getTreasuryFile() == file).findFirst();
    }
}

